/*
 * StandardImageFunctions.cpp
 *
 *  Created on: Jan 7, 2009
 *      Author: atabb
 */

#include "StandardImageFunctions.hpp"


double ReturnImageColor( IplImage* I, int r, int c, int ch) {
	double t = double(((uchar*)(I->imageData + I->widthStep*(r)))[I->nChannels*c + ch]);
	return t;
}

void SetImageColor( IplImage* I, int r, int c, int ch, int color) {
	(((uchar*)(I->imageData + I->widthStep*(r)))[I->nChannels*c + ch]) = color;
}

void SetImageColor( IplImage* I, int r, int c, int ch, unsigned char color) {
	(((uchar*)(I->imageData + I->widthStep*(r)))[I->nChannels*c + ch]) = color;
}

int GetImageColor( IplImage* I, int r, int c, int ch) {
	return int((((uchar*)(I->imageData + I->widthStep*(r)))[I->nChannels*c + ch]));
}


