/*
 * RobotWorldHandEyeCali1.cpp
 *
 *  Revised: Jan 31, 2015
 *      Author: atabb
 *      This code is the companion to the IROS2015 submitted paper "Parameterizations for Reducing Camera Reprojection Error for Robot-World Hand-Eye Calibration"
 *      authors Amy Tabb and Khalil M. Ahmad Yousef.  No warranties are expressed or implied.
 *
 *      This code is also considered confidential and non-public until the time of publication of the above-named paper.
 */



#include <stdio.h>
#include "DirectoryFunctions.hpp"
#include "RWHECali.hpp"
#include "RobotWorldHandEyeCaliMain.hpp"
#include "Calibration2.hpp"

using namespace std;
using namespace cv;

int main(int argc, char **argv)
{

	string internal_dir;
	string external_dir;
	string write_dir;
	string robot_file = "";
	string robot_dir;
	string hand_eye_dir;
	string cali_object_file;

	///////////////////////  DATASETS PATH SELECTION ///////////////////////


	double  chess_mm_height = 0;
	double chess_mm_width = 0;
	int chess_height = 0;
	int chess_width = 0;

	cout << "Usage for calibration is function_name robot_directory. Full path is needed for robot_directory " << endl;

	if (argc == 2){
		internal_dir =  string(argv[1]) + "/images";
		write_dir = argv[1];
		robot_file = string(argv[1]) + "/cali.txt";
		cali_object_file =  string(argv[1]) + "/calibration_object.txt";
	}	else {
		cout << "Wrong number of arguments " << endl;
		exit(1);
	}

	ifstream in;
	in.open(cali_object_file.c_str());

	if (!in){
		cout << "You forgot the calibration_object.txt file or the path is wrong" << endl << argv[1] << endl;;
		exit(1);
	}


	string temp;
	in >> temp >> chess_mm_height;
	in >> temp >> chess_mm_width;
	in >> temp >> chess_height;
	in >> temp >> chess_width;

	RobotWorldHandEyeCalibration(chess_mm_width, chess_mm_height,
			chess_height, chess_width,  internal_dir, write_dir, robot_file);

	return(0);
}


int RobotWorldHandEyeCalibration(double square_mm_height, double square_mm_width,
		int chess_h, int chess_w, string internal_dir, string write_dir, string robot_position_file){

	//testin AX = ZB
	string command;
	command = "rm -r " + write_dir + "/camera_results";
	int ret = system(command.c_str());

	command = "mkdir " + write_dir + "/camera_results";
	ret = system(command.c_str());


	char ch;
	vector<string> window_names;
	string name;

	std::ofstream out;
	string filename = write_dir + "/camera_results/details.txt";
	out.open(filename.c_str());

	string external_dir = write_dir + "/images";

	/////////////////////// START CAMERA CALIBRATION/////////////////////////
	CaliObjectOpenCV2 CO(0, chess_w, chess_h,
			square_mm_width, square_mm_height);


	//Do calibration based on the internal directory
	if (external_dir != internal_dir){
		CO.ReadImages(internal_dir, 0);
	}else
	{
		CO.ReadImages(external_dir, 1);
	}

	//Argument is whether or not to draw the corners
	CO.AccumulateCorners(false);

	CO.Calibrate(out,  write_dir + "/camera_results");
	out.close();

	///////////////////////  write calibration file ///////////////////////
	filename = write_dir + "/camera_results/cali.txt";
	out.open(filename.c_str());
	WriteCaliFile(&CO, out);
	out.close();

	Matrix A1(4, 4);
	Matrix B1(4, 4);
	vector<Matrix> As;
	vector<Matrix> Bs;

	int number_cameras = CO.Rts.size();

	// convert the external parameters from the camera calibration process into the A matrices
	for (int i = 0; i < int(CO.Rts.size()); i++){
		A1 = 0;
		A1(4, 4) = 1;

		for (int r = 0; r < 3; r++){
			for (int c = 0; c < 4; c++){
				A1(r + 1, c + 1) = CO.Rts[i][r][c];
			}
		}
		As.push_back(A1);
	}

	/////////////////////////// END CAMERA CALIBRATION ////////////////////////////

	Matrix Rz(3, 3);
	Matrix Ry(3, 3);
	Matrix Rx(3, 3);

	////////////////////////// ROBOT SECTION /////////////////////////////////////////

	filename = write_dir + "/robot_cali.txt";
	DIR * dir = opendir (filename.c_str());
	if (dir == NULL){
		cout << "Dir is null... " << endl;
		ReadRobotFileDensoArm(write_dir, Bs);
	}	else {
		ReadRobotFileRobotCaliTxt(write_dir, Bs);
	}

	char gh;

	command = "rm -r " + write_dir + "/robot";
	system(command.c_str());

	command = "mkdir " + write_dir + "/robot";
	system(command.c_str());


	filename = write_dir + "/robot/cali.txt";
	out.open(filename.c_str());

	WriteCaliFile(&CO, Bs, out);
	out.close();


	Matrix I(3, 3);
	I = 0;
	I(1, 1) = 1;
	I(2, 2) = 1;
	I(3, 3) = 1;

	Matrix TestR(3, 3);
	Matrix X(4, 4);
	Matrix Z(4, 4);

	X = 0; X(4, 4) = 1;
	Z = 0; Z(4, 4) = 1;

	vector<double> rotation_error;
	vector<double> translation_error;
	vector<double> whole_error;
	vector<double> reprojection_error;
	vector<double> squared_translation_error;
	vector<double> denominator_error;
	vector<string> name_vector;

	string descriptor_string;

	for (int option = 0; option < 4; option++ ){

		command = "rm -r " + write_dir + "/hand_eye_results" + ToString<int>(option);
		system(command.c_str());

		command = "mkdir " + write_dir + "/hand_eye_results" + ToString<int>(option);
		system(command.c_str());

		filename = write_dir + "/hand_eye_results" + ToString<int>(option) + "/details.txt";

		out.open(filename.c_str());

		switch (option){
		case 0: {
			descriptor_string = "Euler parameterzation I ";
			out << "Euler parameterization, ||AX-ZB||, no reprojection error" << endl;
			X = 0; X(4, 4) = 1;
			Z = 0; Z(4, 4) = 1;
			X.SubMatrix(1, 3, 1, 3) = I;
			Z.SubMatrix(1, 3, 1, 3) = I;
			LevMarMethodWithAngles(As, Bs, X, Z, out);
		} break;
		case 1: {
			descriptor_string = "Euler parameterzation II ";
			out << "Euler parameterization, ||A-ZBX^-1||, no reprojection error" << endl;

			X = 0; X(4, 4) = 1;
			Z = 0; Z(4, 4) = 1;
			X.SubMatrix(1, 3, 1, 3) = I;
			Z.SubMatrix(1, 3, 1, 3) = I;

			LevMarMethodWithAnglesRepII(As, Bs, X, Z, out);
		} break;
		case 2: {
			descriptor_string = "Reprojection error w/o intrinisics ";
			out << "Minimization of reprojection error w/o intrinisics " << endl;
			X = 0; X(4, 4) = 1;
			Z = 0; Z(4, 4) = 1;
			X.SubMatrix(1, 3, 1, 3) = I;
			Z.SubMatrix(1, 3, 1, 3) = I;
			// initialize ...
			LevMarMethodWithAngles(As, Bs, X, Z, out);
			LevMarMethodReprojectionError2(As, Bs, X, Z, &CO, out);

		} break;
		case 3: {
			descriptor_string = "Reprojection error w intrinisics ";
			out << "Minimization of reprojection error w/ intrinisics " << endl;
			X = 0; X(4, 4) = 1;
			Z = 0; Z(4, 4) = 1;
			X.SubMatrix(1, 3, 1, 3) = I;
			Z.SubMatrix(1, 3, 1, 3) = I;
			// initialize ...
			LevMarMethodWithAngles(As, Bs, X, Z, out);
			LevMarMethodReprojectionError3(As, Bs, X, Z, &CO, out);

		} break;
		}


		name_vector.push_back(descriptor_string);

		cout << "X " << endl << X << endl;
		cout << "Z " << endl << Z << endl;

		out << "X " << endl << X << endl;
		out << "Z " << endl << Z << endl;


		double error;

		error = AssessRotationError(As, Bs, X, Z);
		out << "Summed rotation error " << error << endl;
		rotation_error.push_back(error);

		error = AssessTranslationError(As, Bs, X, Z);
		out << "Summed translation error " << error << endl;
		translation_error.push_back(error);
		squared_translation_error.push_back(error*error);

		error = AssessTranslationErrorDenominator(As, Bs, X, Z);
		denominator_error.push_back(error*error);

		error = AssessErrorWhole(As, Bs, X, Z);
		out << "Summed whole error " << error << endl;
		whole_error.push_back(error);


		//  "Reprojection_error: RSSE"
		error = CalculateReprojectionError(&CO, As, Bs, X, Z, out,  write_dir + "/hand_eye_results" +  ToString<int>(option));
		reprojection_error.push_back(error);
		out.close();


		filename = write_dir + "/hand_eye_results" +  ToString<int>(option) + "/transformations.txt";
		out.open(filename.c_str());
		out << "X" << endl << X;
		out << "Z" << endl << Z << endl;
		out.close();

		filename = write_dir + "/hand_eye_results" +  ToString<int>(option) + "/cali.txt";
		out.open(filename.c_str());

		WriteCaliFile(&CO, As, Bs, X, Z, out);

		out.close();

	}

	filename = write_dir + "/comparisons.txt";
	out.open(filename.c_str());

	out << setw(36) << "Method name "
			<< setw(20) << "Rotation error"
			<< setw(20) << "Translation error"
			<< setw(20) << "Whole error"
			<< setw(20) << "reprojection error"
			<< setw(20) << "RMS reprojection" << endl;

	for (int i = 0; i < int(rotation_error.size()); i++){
		out << i << " " << setw(36);
		out << name_vector[i];
		out << setw(20) << rotation_error[i]
		                                  << setw(20) <<  translation_error[i]
		                                                                    << setw(20) << whole_error[i]
		                                                                                               << setw(20) << reprojection_error[i]
		                                                                                                                                 << setw(20) <<  sqrt((1.0/double(As.size()*CO.all_3d_corners[0].size())) * reprojection_error[i]) << endl;
	}


	out << endl;
	out << "___________________________________________________________________________________" << endl;
	out << endl;
	out << "Now errors are normalized by the number of robot positions, which is " << number_cameras << "  excepting the rms" << endl;
	out << setw(36) << "Method name "
			<< setw(20) << "Rotation error"
			<< setw(20) << "Translation error"
			<< setw(20) << "Whole error"
			<< setw(20) << "reprojection error"
			<< setw(20) << "RMS reprojection"
			<< setw(20) << "D&H translation error"<< endl;
	for (int i = 0; i < int(rotation_error.size()); i++){
		out << i << " " << setw(36);
		out << name_vector[i];
		out << setw(20) << rotation_error[i]/double(number_cameras)
												<< setw(20) <<  translation_error[i]/double(number_cameras)
												<< setw(20) << whole_error[i]/double(number_cameras)
												<< setw(20) << reprojection_error[i]/double(number_cameras)
												<< setw(20) <<  sqrt((1.0/double(As.size()*CO.all_3d_corners[0].size())) * reprojection_error[i])
												<< setw(20) <<sqrt(squared_translation_error[i]/denominator_error[i]) << endl;
	}

	out.close();

	return 1;

}
