/*
 * HandEyeCali.hpp
 *
 *  Created on: Feb 4, 2014
 *      Author: atabb
 */

#ifndef HANDEYECALI_HPP_
#define HANDEYECALI_HPP_

#include <math.h>
#include <cstdlib>
#include <stdio.h>
#include <iostream>
#include <string>
#include <sstream>
#include <stdlib.h>

#include <opencv/cv.h>
#include <opencv/cxcore.h>
#include <opencv/highgui.h>

#include <math.h>
#include <cstdlib>
#include <iostream>
#include <fstream>
#include "StringFunctions.hpp"


#include "DirectoryFunctions.hpp"

using namespace std;

//#include "GetImages.hpp"
#include "Calibration2.hpp"
//#include "ImageData.hpp"

#include "newmatap.h"     // newmat advanced functions
#include "newmatio.h"     // newmat headers including output functions

using namespace std;

struct CaliData{
	vector<Matrix>* As;
	vector<Matrix>* Bs;
	vector<ColumnVector> world_coordinates;
	vector<double> image_coordinates_x_y;
	CaliObjectOpenCV2* CO;
	double mu1;
	double mu2;
	double mu3;
	double mu4;
};
double AssessRotationError(vector<Matrix>& As, vector<Matrix>& Bs, Matrix& X, Matrix& Z);

double AssessTranslationError(vector<Matrix>& As, vector<Matrix>& Bs, Matrix& X, Matrix& Z);

double AssessErrorWhole(vector<Matrix>& As, vector<Matrix>& Bs, Matrix& X, Matrix& Z);

double AssessTranslationErrorDenominator(vector<Matrix>& As, vector<Matrix>& Bs, Matrix& X, Matrix& Z);

double CalculateReprojectionError(CaliObjectOpenCV2* CO, vector<Matrix>& As, vector<Matrix>& Bs, Matrix& X, Matrix& Z, std::ofstream& out, string directory);




void FDClosedFormMethod(vector<Matrix>& As, vector<Matrix>& Bs, Matrix& X, Matrix& Z, std::ofstream& out);

void FDIterativeMethod(vector<Matrix>& As, vector<Matrix>& Bs, Matrix& X, Matrix& Z, std::ofstream& out);



void LevMarMethodWithAngles(vector<Matrix>& As, vector<Matrix>& Bs, Matrix& X, Matrix& Z, std::ofstream& out);

void LevMarMethodWithAnglesRepII(vector<Matrix>& As, vector<Matrix>& Bs, Matrix& X, Matrix& Z, std::ofstream& out);

void LevMarMethodReprojectionError2(vector<Matrix>& As, vector<Matrix>& Bs, Matrix& X, Matrix& Z, CaliObjectOpenCV2* CO, std::ofstream& out);

void LevMarMethodReprojectionError3(vector<Matrix>& As, vector<Matrix>& Bs, Matrix& X, Matrix& Z, CaliObjectOpenCV2* CO, std::ofstream& out);


void ReadRobotFileDensoArm(string write_dir, vector<Matrix>& Bs);

void ReadRobotFileRobotCaliTxt(string write_dir, vector<Matrix>& Bs);


void RVLMethod(vector<Matrix>& As, vector<Matrix>& Bs, Matrix& X, Matrix& Z, std::ofstream& out);


//void WriteCaliFile(vector<CaliObject*>& cali_objects, vector<Matrix>& As, vector<Matrix>& Bs, Matrix& X, Matrix& Z, std::ofstream& out);

void WriteCaliFile(CaliObjectOpenCV2* CO, vector<Matrix>& As, vector<Matrix>& Bs, Matrix& X, Matrix& Z, std::ofstream& out);

void WriteCaliFile(CaliObjectOpenCV2* CO, std::ofstream& out);

void WriteCaliFile(CaliObjectOpenCV2* CO, vector<Matrix>& Bs, std::ofstream& out);



void ZhuangLinearMethod(vector<Matrix>& As, vector<Matrix>& Bs, Matrix& X, Matrix& Z, std::ofstream& out);

void ZhuangLinearMethodRev(vector<Matrix>& As, vector<Matrix>& Bs, Matrix& X, Matrix& Z, std::ofstream& out);


void LiDualQuaternion(vector<Matrix>& As, vector<Matrix>& Bs, Matrix& X, Matrix& Z, std::ofstream& out);

void LiKroneckerProduct(vector<Matrix>& As, vector<Matrix>& Bs, Matrix& X, Matrix& Z, std::ofstream& out);




#endif /* HANDEYECALI_HPP_ */
