/*
 * HandEyeCali.cpp
 *
 *  Created on: Feb 4, 2014
 *      Author: atabb
 */



#include "RWHECali.hpp"
#include <stdio.h>
#include "levmar.h"
#include "Calibration2.hpp"
#include "SimpleFunctions.hpp"

void WriteCaliFile(CaliObjectOpenCV2* CO, vector<Matrix>& As, vector<Matrix>& Bs, Matrix& X, Matrix& Z, std::ofstream& out){
	out << As.size() << endl;
	Matrix newA(4, 4);

	vector<Matrix> newAs;
	int n = As.size();
	for (int i = 0; i < n; i++){

		newA = Z*Bs[i]*X.i();

		out << "image" << ToString<int>(i) << ".png " << " ";
		for (int r = 0; r < 3; r++){
			for (int c = 0; c < 3; c++){
				out << CO->A[r][c] << " ";
			}
		}

		for (int r = 0; r < 3; r++){
			for (int c = 0; c < 3; c++){
				out << newA(r + 1,c + 1) << " ";
			}
		}

		for (int r = 0; r < 3; r++){
			out << newA(r + 1,4) << " ";
		}

		for (int r = 0; r < int(CO->k.size()); r++){
			out << CO->k[r] << " ";
		}

		out << endl;

	}
}

void WriteCaliFile(CaliObjectOpenCV2* CO, std::ofstream& out){
	out << CO->Rts.size() << endl;

	for (int i = 0; i < int(CO->Rts.size()); i++){

		out << "image" << ToString<int>(i) << ".png " << " ";
		for (int r = 0; r < 3; r++){
			for (int c = 0; c < 3; c++){
				out << CO->A[r][c] << " ";
			}
		}

		for (int r = 0; r < 3; r++){
			for (int c = 0; c < 3; c++){
				out << CO->Rts[i][r][c] << " ";;
			}
		}

		for (int r = 0; r < 3; r++){
			out << CO->Rts[i][r][3] << " ";;
		}

		for (int r = 0; r < int(CO->k.size()); r++){
			out << CO->k[r] << " ";
		}

		out << endl;
	}
}

void WriteCaliFile(CaliObjectOpenCV2* CO, vector<Matrix>& Bs, std::ofstream& out){
	out << CO->Rts.size() << endl;

	for (int i = 0; i < int(CO->Rts.size()); i++){

		out << "image" << ToString<int>(i) << ".png " << " ";
		for (int r = 0; r < 3; r++){
			for (int c = 0; c < 3; c++){
				out << CO->A[r][c] << " ";
			}
		}

		for (int r = 0; r < 3; r++){
			for (int c = 0; c < 3; c++){
				out << Bs[i](r + 1,c + 1) << " ";;
			}
		}

		for (int r = 0; r < 3; r++){
			out << Bs[i](r + 1,4) << " ";;
		}

		for (int r = 0; r < int(CO->k.size()); r++){
			out << CO->k[r] << " ";
		}

		out << endl;
	}
}


void residuals_euler1(double *p, double *x, int m, int n, void *data){

	//	char ch;
	CaliData *dptr;

	dptr=(CaliData*)data;


	int index = 0;

	// get the current parameters ...

	double thetax_X = p[0];
	double thetay_X = p[1];
	double thetaz_X = p[2];
	double t0X = p[3];
	double t1X = p[4];
	double t2X = p[5];

	double thetax_Z = p[6];
	double thetay_Z = p[7];
	double thetaz_Z = p[8];
	double t0Z = p[9];
	double t1Z = p[10];
	double t2Z = p[11];

	double a0, a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11;
	double b0, b1, b2, b3, b4, b5, b6, b7, b8, b9, b10, b11;

	for (int i = 0; i < int(dptr->As->size()); i++){
		a0 = dptr->As->at(i)(1, 1);
		a1 = dptr->As->at(i)(1, 2);
		a2 = dptr->As->at(i)(1, 3);
		a3 = dptr->As->at(i)(1, 4);

		a4 = dptr->As->at(i)(2, 1);
		a5 = dptr->As->at(i)(2, 2);
		a6 = dptr->As->at(i)(2, 3);
		a7 = dptr->As->at(i)(2, 4);

		a8 = dptr->As->at(i)(3, 1);
		a9 = dptr->As->at(i)(3, 2);
		a10 = dptr->As->at(i)(3, 3);
		a11 = dptr->As->at(i)(3, 4);

		b0 = dptr->Bs->at(i)(1, 1);
		b1 = dptr->Bs->at(i)(1, 2);
		b2 = dptr->Bs->at(i)(1, 3);
		b3 = dptr->Bs->at(i)(1, 4);

		b4 = dptr->Bs->at(i)(2, 1);
		b5 = dptr->Bs->at(i)(2, 2);
		b6 = dptr->Bs->at(i)(2, 3);
		b7 = dptr->Bs->at(i)(2, 4);

		b8 = dptr->Bs->at(i)(3, 1);
		b9 = dptr->Bs->at(i)(3, 2);
		b10 = dptr->Bs->at(i)(3, 3);
		b11 = dptr->Bs->at(i)(3, 4);

		x[index] = b4*cos(thetay_Z)*sin(thetaz_Z)-b0*cos(thetay_Z)*cos(thetaz_Z)
                                    																														  +a2*(sin(thetax_X)*sin(thetaz_X)
                                    																																  -cos(thetax_X)*sin(thetay_X)*cos(thetaz_X))
                                    																																  +a1*(cos(thetax_X)*sin(thetaz_X)
                                    																																		  +sin(thetax_X)*sin(thetay_X)*cos(thetaz_X))
                                    																																		  +a0*cos(thetay_X)*cos(thetaz_X)-b8*sin(thetay_Z);


		x[index + 1] = b5*cos(thetay_Z)*sin(thetaz_Z)-b1*cos(thetay_Z)*cos(thetaz_Z)
                                    																														  +a1*(cos(thetax_X)*cos(thetaz_X)
                                    																																  -sin(thetax_X)*sin(thetay_X)*sin(thetaz_X))
                                    																																  +a2*(cos(thetax_X)*sin(thetay_X)*sin(thetaz_X)
                                    																																		  +sin(thetax_X)*cos(thetaz_X))
                                    																																		  -a0*cos(thetay_X)*sin(thetaz_X)-b9*sin(thetay_Z);

		x[index + 2 ] = b6*cos(thetay_Z)*sin(thetaz_Z)-b2*cos(thetay_Z)*cos(thetaz_Z)
                                    																														  -b10*sin(thetay_Z)+a0*sin(thetay_X)
		-a1*sin(thetax_X)*cos(thetay_X)
		+a2*cos(thetax_X)*cos(thetay_X);

		x[index + 3] = b7*cos(thetay_Z)*sin(thetaz_Z)-b3*cos(thetay_Z)*cos(thetaz_Z)
                                    																														  -b11*sin(thetay_Z)+a2*t2X+a1*t1X-t0Z+a0*t0X+a3;

		x[index + 4] = -b4*(cos(thetax_Z)*cos(thetaz_Z)-sin(thetax_Z)*sin(thetay_Z)*sin(thetaz_Z))
																																 -b0*(cos(thetax_Z)*sin(thetaz_Z)+sin(thetax_Z)*sin(thetay_Z)*cos(thetaz_Z))
																																 +a6*(sin(thetax_X)*sin(thetaz_X)-cos(thetax_X)*sin(thetay_X)*cos(thetaz_X))
																																 +a5*(cos(thetax_X)*sin(thetaz_X)+sin(thetax_X)*sin(thetay_X)*cos(thetaz_X))
																																 +a4*cos(thetay_X)*cos(thetaz_X)+b8*sin(thetax_Z)*cos(thetay_Z);

		x[index + 5] = -b5*(cos(thetax_Z)*cos(thetaz_Z)-sin(thetax_Z)*sin(thetay_Z)*sin(thetaz_Z))
																																 -b1*(cos(thetax_Z)*sin(thetaz_Z)+sin(thetax_Z)*sin(thetay_Z)*cos(thetaz_Z))
																																 +a5*(cos(thetax_X)*cos(thetaz_X)-sin(thetax_X)*sin(thetay_X)*sin(thetaz_X))
																																 +a6*(cos(thetax_X)*sin(thetay_X)*sin(thetaz_X)+sin(thetax_X)*cos(thetaz_X))
																																 -a4*cos(thetay_X)*sin(thetaz_X)+b9*sin(thetax_Z)*cos(thetay_Z);

		x[index + 6] = -b6*(cos(thetax_Z)*cos(thetaz_Z)-sin(thetax_Z)*sin(thetay_Z)*sin(thetaz_Z))
																																 -b2*(cos(thetax_Z)*sin(thetaz_Z)+sin(thetax_Z)*sin(thetay_Z)*cos(thetaz_Z))
																																 +b10*sin(thetax_Z)*cos(thetay_Z)+a4*sin(thetay_X)
		-a5*sin(thetax_X)*cos(thetay_X)+a6*cos(thetax_X)*cos(thetay_X);

		x[index + 7] = -b7*(cos(thetax_Z)*cos(thetaz_Z)-sin(thetax_Z)*sin(thetay_Z)*sin(thetaz_Z))
																																 -b3*(cos(thetax_Z)*sin(thetaz_Z)+sin(thetax_Z)*sin(thetay_Z)*cos(thetaz_Z))
																																 +b11*sin(thetax_Z)*cos(thetay_Z)+a6*t2X-t1Z+a5*t1X+a4*t0X+a7;

		x[index + 8] = -b4*(cos(thetax_Z)*sin(thetay_Z)*sin(thetaz_Z)+sin(thetax_Z)*cos(thetaz_Z))
																																 -b0*(sin(thetax_Z)*sin(thetaz_Z)-cos(thetax_Z)*sin(thetay_Z)*cos(thetaz_Z))
																																 +a10*(sin(thetax_X)*sin(thetaz_X)-cos(thetax_X)*sin(thetay_X)*cos(thetaz_X))
																																 +a9*(cos(thetax_X)*sin(thetaz_X)+sin(thetax_X)*sin(thetay_X)*cos(thetaz_X))
																																 +a8*cos(thetay_X)*cos(thetaz_X)-b8*cos(thetax_Z)*cos(thetay_Z);

		x[index + 9] = -b5*(cos(thetax_Z)*sin(thetay_Z)*sin(thetaz_Z)+sin(thetax_Z)*cos(thetaz_Z))
																																 -b1*(sin(thetax_Z)*sin(thetaz_Z)-cos(thetax_Z)*sin(thetay_Z)*cos(thetaz_Z))
																																 +a9*(cos(thetax_X)*cos(thetaz_X)-sin(thetax_X)*sin(thetay_X)*sin(thetaz_X))
																																 +a10*(cos(thetax_X)*sin(thetay_X)*sin(thetaz_X)+sin(thetax_X)*cos(thetaz_X))
																																 -a8*cos(thetay_X)*sin(thetaz_X)-b9*cos(thetax_Z)*cos(thetay_Z);

		x[index + 10] = -b6*(cos(thetax_Z)*sin(thetay_Z)*sin(thetaz_Z)+sin(thetax_Z)*cos(thetaz_Z))
																																 -b2*(sin(thetax_Z)*sin(thetaz_Z)-cos(thetax_Z)*sin(thetay_Z)*cos(thetaz_Z))
																																 -b10*cos(thetax_Z)*cos(thetay_Z)+a8*sin(thetay_X)
		-a9*sin(thetax_X)*cos(thetay_X)+a10*cos(thetax_X)*cos(thetay_X);

		x[index + 11] = -b7*(cos(thetax_Z)*sin(thetay_Z)*sin(thetaz_Z)+sin(thetax_Z)*cos(thetaz_Z))
																																 -b3*(sin(thetax_Z)*sin(thetaz_Z)-cos(thetax_Z)*sin(thetay_Z)*cos(thetaz_Z))
																																 -b11*cos(thetax_Z)*cos(thetay_Z)-t2Z+a10*t2X+a9*t1X+a8*t0X+a11;

		index += 12;
	}

}

void jacobian_euler1(double *p, double *jac, int m, int n, void *data){
	CaliData *dptr;

	dptr=(CaliData*)data;


	int index = 0;

	// get the current parameters ...

	double thetax_X = p[0];
	double thetay_X = p[1];
	double thetaz_X = p[2];
	double t0X = p[3];
	double t1X = p[4];
	double t2X = p[5];

	double thetax_Z = p[6];
	double thetay_Z = p[7];
	double thetaz_Z = p[8];
	double t0Z = p[9];
	double t1Z = p[10];
	double t2Z = p[11];

	double a0, a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11;
	double b0, b1, b2, b3, b4, b5, b6, b7, b8, b9, b10, b11;

	for (int i = 0; i < int(dptr->As->size()); i++){
		a0 = dptr->As->at(i)(1, 1);
		a1 = dptr->As->at(i)(1, 2);
		a2 = dptr->As->at(i)(1, 3);
		a3 = dptr->As->at(i)(1, 4);

		a4 = dptr->As->at(i)(2, 1);
		a5 = dptr->As->at(i)(2, 2);
		a6 = dptr->As->at(i)(2, 3);
		a7 = dptr->As->at(i)(2, 4);

		a8 = dptr->As->at(i)(3, 1);
		a9 = dptr->As->at(i)(3, 2);
		a10 = dptr->As->at(i)(3, 3);
		a11 = dptr->As->at(i)(3, 4);

		b0 = dptr->Bs->at(i)(1, 1);
		b1 = dptr->Bs->at(i)(1, 2);
		b2 = dptr->Bs->at(i)(1, 3);
		b3 = dptr->Bs->at(i)(1, 4);

		b4 = dptr->Bs->at(i)(2, 1);
		b5 = dptr->Bs->at(i)(2, 2);
		b6 = dptr->Bs->at(i)(2, 3);
		b7 = dptr->Bs->at(i)(2, 4);

		b8 = dptr->Bs->at(i)(3, 1);
		b9 = dptr->Bs->at(i)(3, 2);
		b10 = dptr->Bs->at(i)(3, 3);
		b11 = dptr->Bs->at(i)(3, 4);

		// d r0
		jac[index] = a1*(cos(thetax_X)*sin(thetay_X)*cos(thetaz_X)-sin(thetax_X)*sin(thetaz_X))
																																 +a2*(cos(thetax_X)*sin(thetaz_X)+sin(thetax_X)*sin(thetay_X)*cos(thetaz_X));

		jac[index + 1] = -a0*sin(thetay_X)*cos(thetaz_X)+a1*sin(thetax_X)*cos(thetay_X)*cos(thetaz_X)
                                    																														   -a2*cos(thetax_X)*cos(thetay_X)*cos(thetaz_X);

		jac[index + 2] = a1*(cos(thetax_X)*cos(thetaz_X)-sin(thetax_X)*sin(thetay_X)*sin(thetaz_X))
																																 +a2*(cos(thetax_X)*sin(thetay_X)*sin(thetaz_X)+sin(thetax_X)*cos(thetaz_X))
																																 -a0*cos(thetay_X)*sin(thetaz_X);

		jac[index + 3] = 0;
		jac[index + 4] = 0;
		jac[index + 5] = 0;

		jac[index + 6] = 0;
		jac[index + 7] = -b4*sin(thetay_Z)*sin(thetaz_Z)+b0*sin(thetay_Z)*cos(thetaz_Z)
                                    																														   -b8*cos(thetay_Z);
		jac[index + 8] = b0*cos(thetay_Z)*sin(thetaz_Z)+b4*cos(thetay_Z)*cos(thetaz_Z);

		jac[index + 9] = 0;
		jac[index + 10] =0;
		jac[index + 11] =0;

		index += 12;

		// d r1
		jac[index] = a2*(cos(thetax_X)*cos(thetaz_X)-sin(thetax_X)*sin(thetay_X)*sin(thetaz_X))
		    																																		+a1*(-cos(thetax_X)*sin(thetay_X)*sin(thetaz_X)-sin(thetax_X)*cos(thetaz_X));
		jac[index + 1] = a0*sin(thetay_X)*sin(thetaz_X)-a1*sin(thetax_X)*cos(thetay_X)*sin(thetaz_X)
                                    																																		  +a2*cos(thetax_X)*cos(thetay_X)*sin(thetaz_X);
		jac[index + 2] = a2*(cos(thetax_X)*sin(thetay_X)*cos(thetaz_X)-sin(thetax_X)*sin(thetaz_X))
																																				 +a1*(-cos(thetax_X)*sin(thetaz_X)-sin(thetax_X)*sin(thetay_X)*cos(thetaz_X))
																																				 -a0*cos(thetay_X)*cos(thetaz_X);

		jac[index + 3] = 0;
		jac[index + 4] = 0;
		jac[index + 5] = 0;

		jac[index + 6] = 0;
		jac[index + 7] =-b5*sin(thetay_Z)*sin(thetaz_Z)+b1*sin(thetay_Z)*cos(thetaz_Z)
                                    																																   -b9*cos(thetay_Z);
		jac[index + 8] =b1*cos(thetay_Z)*sin(thetaz_Z)+b5*cos(thetay_Z)*cos(thetaz_Z);


		jac[index + 9] = 0;
		jac[index + 10] =0;
		jac[index + 11] =0;

		index += 12;


		////////d r2
		jac[index] = -a2*sin(thetax_X)*cos(thetay_X)-a1*cos(thetax_X)*cos(thetay_X);
		jac[index + 1] = a1*sin(thetax_X)*sin(thetay_X)-a2*cos(thetax_X)*sin(thetay_X)+a0*cos(thetay_X);
		jac[index + 2]= 0;


		jac[index + 3] = 0;
		jac[index + 4] = 0;
		jac[index + 5] = 0;

		jac[index + 6] = 0;
		jac[index + 7] = -b6*sin(thetay_Z)*sin(thetaz_Z)+b2*sin(thetay_Z)*cos(thetaz_Z)
                                    																																   -b10*cos(thetay_Z);
		jac[index + 8] = b2*cos(thetay_Z)*sin(thetaz_Z)+b6*cos(thetay_Z)*cos(thetaz_Z);

		jac[index + 9] = 0;
		jac[index + 10] =0;
		jac[index + 11] =0;

		index += 12;

		///// d r3

		jac[index] = 0;
		jac[index + 1] = 0;
		jac[index + 2] = 0;

		jac[index + 3] = a0;
		jac[index + 4] = a1;
		jac[index + 5] = a2;

		jac[index + 6] = 0;
		jac[index + 7] = -b7*sin(thetay_Z)*sin(thetaz_Z)+b3*sin(thetay_Z)*cos(thetaz_Z)
                                    																																   -b11*cos(thetay_Z);
		jac[index + 8] = b3*cos(thetay_Z)*sin(thetaz_Z)+b7*cos(thetay_Z)*cos(thetaz_Z);

		jac[index + 9] = -1;
		jac[index + 10] = 0;
		jac[index + 11] = 0;

		index += 12;

		////// d r4
		jac[index] = a5*(cos(thetax_X)*sin(thetay_X)*cos(thetaz_X)-sin(thetax_X)*sin(thetaz_X))
																																		 +a6*(cos(thetax_X)*sin(thetaz_X)+sin(thetax_X)*sin(thetay_X)*cos(thetaz_X));
		jac[index + 1] = -a4*sin(thetay_X)*cos(thetaz_X)+a5*sin(thetax_X)*cos(thetay_X)*cos(thetaz_X)
                                    																																   -a6*cos(thetax_X)*cos(thetay_X)*cos(thetaz_X);
		jac[index + 2] = a5*(cos(thetax_X)*cos(thetaz_X)-sin(thetax_X)*sin(thetay_X)*sin(thetaz_X))
																																		 +a6*(cos(thetax_X)*sin(thetay_X)*sin(thetaz_X)+sin(thetax_X)*cos(thetaz_X))
																																		 -a4*cos(thetay_X)*sin(thetaz_X);

		jac[index + 3] = 0;
		jac[index + 4] = 0;
		jac[index + 5] = 0;

		jac[index + 6] = -b4*(-cos(thetax_Z)*sin(thetay_Z)*sin(thetaz_Z)-sin(thetax_Z)*cos(thetaz_Z))
																																		 -b0*(cos(thetax_Z)*sin(thetay_Z)*cos(thetaz_Z)-sin(thetax_Z)*sin(thetaz_Z))
																																		 +b8*cos(thetax_Z)*cos(thetay_Z);
		jac[index + 7] = b4*sin(thetax_Z)*cos(thetay_Z)*sin(thetaz_Z)
																																		 -b0*sin(thetax_Z)*cos(thetay_Z)*cos(thetaz_Z)-b8*sin(thetax_Z)*sin(thetay_Z);
		jac[index + 8] = -b0*(cos(thetax_Z)*cos(thetaz_Z)-sin(thetax_Z)*sin(thetay_Z)*sin(thetaz_Z))
																																		 -b4*(-cos(thetax_Z)*sin(thetaz_Z)-sin(thetax_Z)*sin(thetay_Z)*cos(thetaz_Z));

		jac[index + 9] = 0;
		jac[index + 10] = 0;
		jac[index + 11] = 0;

		index += 12;

		/////// d r5

		jac[index] = a6*(cos(thetax_X)*cos(thetaz_X)-sin(thetax_X)*sin(thetay_X)*sin(thetaz_X))
																																				 +a5*(-cos(thetax_X)*sin(thetay_X)*sin(thetaz_X)-sin(thetax_X)*cos(thetaz_X));
		jac[index + 1] = a4*sin(thetay_X)*sin(thetaz_X)-a5*sin(thetax_X)*cos(thetay_X)*sin(thetaz_X)
                                    																																				  +a6*cos(thetax_X)*cos(thetay_X)*sin(thetaz_X);
		jac[index + 2] = a6*(cos(thetax_X)*sin(thetay_X)*cos(thetaz_X)-sin(thetax_X)*sin(thetaz_X))
																																						 +a5*(-cos(thetax_X)*sin(thetaz_X)-sin(thetax_X)*sin(thetay_X)*cos(thetaz_X))
																																						 -a4*cos(thetay_X)*cos(thetaz_X);

		jac[index + 3] = 0;
		jac[index + 4] = 0;
		jac[index + 5] = 0;

		jac[index + 6] =-b5*(-cos(thetax_Z)*sin(thetay_Z)*sin(thetaz_Z)-sin(thetax_Z)*cos(thetaz_Z))
																																				 -b1*(cos(thetax_Z)*sin(thetay_Z)*cos(thetaz_Z)-sin(thetax_Z)*sin(thetaz_Z))
																																				 +b9*cos(thetax_Z)*cos(thetay_Z);
		jac[index + 7] = b5*sin(thetax_Z)*cos(thetay_Z)*sin(thetaz_Z)
																																				 -b1*sin(thetax_Z)*cos(thetay_Z)*cos(thetaz_Z)-b9*sin(thetax_Z)*sin(thetay_Z);
		jac[index + 8] = -b1*(cos(thetax_Z)*cos(thetaz_Z)-sin(thetax_Z)*sin(thetay_Z)*sin(thetaz_Z))
																																				 -b5*(-cos(thetax_Z)*sin(thetaz_Z)-sin(thetax_Z)*sin(thetay_Z)*cos(thetaz_Z));

		jac[index + 9] = 0;
		jac[index + 10] = 0;
		jac[index + 11] = 0;

		index += 12;

		/////////// d r6
		jac[index + 0] = -a6*sin(thetax_X)*cos(thetay_X)-a5*cos(thetax_X)*cos(thetay_X);
		jac[index + 1] = a5*sin(thetax_X)*sin(thetay_X)-a6*cos(thetax_X)*sin(thetay_X)+a4*cos(thetay_X);
		jac[index + 2] = 0;

		jac[index + 3] = 0;
		jac[index + 4] = 0;
		jac[index + 5] = 0;

		jac[index + 6] = -b6*(-cos(thetax_Z)*sin(thetay_Z)*sin(thetaz_Z)-sin(thetax_Z)*cos(thetaz_Z))
																																		 -b2*(cos(thetax_Z)*sin(thetay_Z)*cos(thetaz_Z)-sin(thetax_Z)*sin(thetaz_Z))
																																		 +b10*cos(thetax_Z)*cos(thetay_Z);
		jac[index + 7] = b6*sin(thetax_Z)*cos(thetay_Z)*sin(thetaz_Z)
																																		 -b2*sin(thetax_Z)*cos(thetay_Z)*cos(thetaz_Z)-b10*sin(thetax_Z)*sin(thetay_Z);
		jac[index + 8] = -b2*(cos(thetax_Z)*cos(thetaz_Z)-sin(thetax_Z)*sin(thetay_Z)*sin(thetaz_Z))
																																		 -b6*(-cos(thetax_Z)*sin(thetaz_Z)-sin(thetax_Z)*sin(thetay_Z)*cos(thetaz_Z));

		jac[index + 9] = 0;
		jac[index + 10] = 0;
		jac[index + 11] = 0;

		index += 12;


		/// d r7
		jac[index + 0] = 0;
		jac[index + 1] = 0;
		jac[index + 2] = 0;

		jac[index + 3] = a4;
		jac[index + 4] = a5;
		jac[index + 5] = a6;

		jac[index + 6] =-b7*(-cos(thetax_Z)*sin(thetay_Z)*sin(thetaz_Z)-sin(thetax_Z)*cos(thetaz_Z))
																																				 -b3*(cos(thetax_Z)*sin(thetay_Z)*cos(thetaz_Z)-sin(thetax_Z)*sin(thetaz_Z))
																																				 +b11*cos(thetax_Z)*cos(thetay_Z);
		jac[index + 7] = b7*sin(thetax_Z)*cos(thetay_Z)*sin(thetaz_Z)
																																				 -b3*sin(thetax_Z)*cos(thetay_Z)*cos(thetaz_Z)-b11*sin(thetax_Z)*sin(thetay_Z);
		jac[index + 8] = -b3*(cos(thetax_Z)*cos(thetaz_Z)-sin(thetax_Z)*sin(thetay_Z)*sin(thetaz_Z))
																																				 -b7*(-cos(thetax_Z)*sin(thetaz_Z)-sin(thetax_Z)*sin(thetay_Z)*cos(thetaz_Z));

		jac[index + 9] = 0;
		jac[index + 10] = -1;
		jac[index + 11] = 0;

		index += 12;

		// d r8 //////////////////////////////////////////////////////
		jac[index + 0] =   a9*(cos(thetax_X)*sin(thetay_X)*cos(thetaz_X)-sin(thetax_X)*sin(thetaz_X))
																																		 +a10*(cos(thetax_X)*sin(thetaz_X)+sin(thetax_X)*sin(thetay_X)*cos(thetaz_X));
		jac[index + 1] =  -a8*sin(thetay_X)*cos(thetaz_X)+a9*sin(thetax_X)*cos(thetay_X)*cos(thetaz_X)
                                    																																   -a10*cos(thetax_X)*cos(thetay_X)*cos(thetaz_X) ;
		jac[index + 2] =  a9*(cos(thetax_X)*cos(thetaz_X)-sin(thetax_X)*sin(thetay_X)*sin(thetaz_X))
																																		 +a10*(cos(thetax_X)*sin(thetay_X)*sin(thetaz_X)+sin(thetax_X)*cos(thetaz_X))
																																		 -a8*cos(thetay_X)*sin(thetaz_X)   ;

		jac[index + 3] =  0   ;
		jac[index + 4] =   0  ;
		jac[index + 5] =    0 ;

		jac[index + 6] = -b4*(cos(thetax_Z)*cos(thetaz_Z)-sin(thetax_Z)*sin(thetay_Z)*sin(thetaz_Z))
																																				 -b0*(cos(thetax_Z)*sin(thetaz_Z)+sin(thetax_Z)*sin(thetay_Z)*cos(thetaz_Z))
																																				 +b8*sin(thetax_Z)*cos(thetay_Z)    ;
		jac[index + 7] =   -b4*cos(thetax_Z)*cos(thetay_Z)*sin(thetaz_Z)
																																				 +b0*cos(thetax_Z)*cos(thetay_Z)*cos(thetaz_Z)+b8*cos(thetax_Z)*sin(thetay_Z)  ;
		jac[index + 8] =  -b0*(cos(thetax_Z)*sin(thetay_Z)*sin(thetaz_Z)+sin(thetax_Z)*cos(thetaz_Z))
																																				 -b4*(cos(thetax_Z)*sin(thetay_Z)*cos(thetaz_Z)-sin(thetax_Z)*sin(thetaz_Z))   ;

		jac[index + 9] =  0   ;
		jac[index + 10] =  0   ;
		jac[index + 11] =   0  ;

		index += 12;

		/////// d r9

		jac[index + 0] = a10*(cos(thetax_X)*cos(thetaz_X)-sin(thetax_X)*sin(thetay_X)*sin(thetaz_X))
																																				 +a9*(-cos(thetax_X)*sin(thetay_X)*sin(thetaz_X)-sin(thetax_X)*cos(thetaz_X))    ;
		jac[index + 1] =  a8*sin(thetay_X)*sin(thetaz_X)-a9*sin(thetax_X)*cos(thetay_X)*sin(thetaz_X)
                                    																																		  +a10*cos(thetax_X)*cos(thetay_X)*sin(thetaz_X)   ;
		jac[index + 2] = a10*(cos(thetax_X)*sin(thetay_X)*cos(thetaz_X)-sin(thetax_X)*sin(thetaz_X))
																																				 +a9*(-cos(thetax_X)*sin(thetaz_X)-sin(thetax_X)*sin(thetay_X)*cos(thetaz_X))
																																				 -a8*cos(thetay_X)*cos(thetaz_X)  ;

		jac[index + 3] = 0    ;
		jac[index + 4] =  0   ;
		jac[index + 5] =   0  ;

		jac[index + 6] = -b5*(cos(thetax_Z)*cos(thetaz_Z)-sin(thetax_Z)*sin(thetay_Z)*sin(thetaz_Z))
																																		 -b1*(cos(thetax_Z)*sin(thetaz_Z)+sin(thetax_Z)*sin(thetay_Z)*cos(thetaz_Z))
																																		 +b9*sin(thetax_Z)*cos(thetay_Z)   ;
		jac[index + 7] =  -b5*cos(thetax_Z)*cos(thetay_Z)*sin(thetaz_Z)
																																		 +b1*cos(thetax_Z)*cos(thetay_Z)*cos(thetaz_Z)+b9*cos(thetax_Z)*sin(thetay_Z)   ;
		jac[index + 8] =  -b1*(cos(thetax_Z)*sin(thetay_Z)*sin(thetaz_Z)+sin(thetax_Z)*cos(thetaz_Z))
																																		 -b5*(cos(thetax_Z)*sin(thetay_Z)*cos(thetaz_Z)-sin(thetax_Z)*sin(thetaz_Z))   ;

		jac[index + 9] =  0   ;
		jac[index + 10] =  0   ;
		jac[index + 11] =   0  ;

		index += 12;

		/// d r10

		jac[index + 0] =  -a10*sin(thetax_X)*cos(thetay_X)-a9*cos(thetax_X)*cos(thetay_X)   ;
		jac[index + 1] =  a9*sin(thetax_X)*sin(thetay_X)-a10*cos(thetax_X)*sin(thetay_X)
                                    																																  +a8*cos(thetay_X)   ;
		jac[index + 2] = 0   ;

		jac[index + 3] =  0   ;
		jac[index + 4] =   0  ;
		jac[index + 5] =    0 ;

		jac[index + 6] =  -b6*(cos(thetax_Z)*cos(thetaz_Z)-sin(thetax_Z)*sin(thetay_Z)*sin(thetaz_Z))
																																		 -b2*(cos(thetax_Z)*sin(thetaz_Z)+sin(thetax_Z)*sin(thetay_Z)*cos(thetaz_Z))
																																		 +b10*sin(thetax_Z)*cos(thetay_Z)   ;
		jac[index + 7] = -b6*cos(thetax_Z)*cos(thetay_Z)*sin(thetaz_Z)
																																		 +b2*cos(thetax_Z)*cos(thetay_Z)*cos(thetaz_Z)+b10*cos(thetax_Z)*sin(thetay_Z)   ;
		jac[index + 8] =  -b2*(cos(thetax_Z)*sin(thetay_Z)*sin(thetaz_Z)+sin(thetax_Z)*cos(thetaz_Z))
																																		 -b6*(cos(thetax_Z)*sin(thetay_Z)*cos(thetaz_Z)-sin(thetax_Z)*sin(thetaz_Z))   ;

		jac[index + 9] =  0   ;
		jac[index + 10] =  0   ;
		jac[index + 11] =   0  ;

		index += 12;

		/// d r11


		jac[index + 0] =  0  ;
		jac[index + 1] =  0  ;
		jac[index + 2] =  0   ;

		jac[index + 3] = a8   ;
		jac[index + 4] =  a9   ;
		jac[index + 5] =   a10  ;

		jac[index + 6] =  -b7*(cos(thetax_Z)*cos(thetaz_Z)-sin(thetax_Z)*sin(thetay_Z)*sin(thetaz_Z))
																																														 -b3*(cos(thetax_Z)*sin(thetaz_Z)+sin(thetax_Z)*sin(thetay_Z)*cos(thetaz_Z))
																																														 +b11*sin(thetax_Z)*cos(thetay_Z)   ;
		jac[index + 7] =  -b7*cos(thetax_Z)*cos(thetay_Z)*sin(thetaz_Z)
																																														 +b3*cos(thetax_Z)*cos(thetay_Z)*cos(thetaz_Z)+b11*cos(thetax_Z)*sin(thetay_Z)   ;
		jac[index + 8] =  -b3*(cos(thetax_Z)*sin(thetay_Z)*sin(thetaz_Z)+sin(thetax_Z)*cos(thetaz_Z))
																																														 -b7*(cos(thetax_Z)*sin(thetay_Z)*cos(thetaz_Z)-sin(thetax_Z)*sin(thetaz_Z))   ;

		jac[index + 9] =    0 ;
		jac[index + 10] =   0  ;
		jac[index + 11] =    -1 ;

		index += 12;


	}

}


void residuals_reprojection2(double *p, double *x, int m, int n, void *data){

	//	char ch;
	CaliData *dptr;

	dptr=(CaliData*)data;


	int index = 0;

	// get the current parameters ...

	double k0 = p[0];
	double k1 = p[1];
	double k2 = p[2];
	double k3 = p[3];
	double k4 = p[4];

	double thetax_X = p[5];
	double thetay_X = p[6];
	double thetaz_X = p[7];
	double t0X = p[8];
	double t1X = p[9];
	double t2X = p[10];

	double thetax_Z = p[11];
	double thetay_Z = p[12];
	double thetaz_Z = p[13];
	double t0Z = p[14];
	double t1Z = p[15];
	double t2Z = p[16];

	double dist1;
	double dist2;
	double dist3;
	double dist4;
	double dist5;
	double dist6;
	double p1;
	double p2;

	dist1 = dptr->CO->k[0];
	dist2 = dptr->CO->k[1];
	p1 = dptr->CO->k[2];
	p2 = dptr->CO->k[3];
	dist3 = dptr->CO->k[4];
	dist4 = dptr->CO->k[5];
	dist5 = dptr->CO->k[6];
	dist6 = dptr->CO->k[7];

	//double a0, a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11;
	double b0, b1, b2, b3, b4, b5, b6, b7, b8, b9, b10, b11;

	double W0, W1, W2;

	for (int i = 0; i < int(dptr->As->size()); i++){

		b0 = dptr->Bs->at(i)(1, 1);
		b1 = dptr->Bs->at(i)(1, 2);
		b2 = dptr->Bs->at(i)(1, 3);
		b3 = dptr->Bs->at(i)(1, 4);

		b4 = dptr->Bs->at(i)(2, 1);
		b5 = dptr->Bs->at(i)(2, 2);
		b6 = dptr->Bs->at(i)(2, 3);
		b7 = dptr->Bs->at(i)(2, 4);

		b8 = dptr->Bs->at(i)(3, 1);
		b9 = dptr->Bs->at(i)(3, 2);
		b10 = dptr->Bs->at(i)(3, 3);
		b11 = dptr->Bs->at(i)(3, 4);


		for (int j = 0; j < dptr->world_coordinates.size(); j++){

			W0 = dptr->world_coordinates[j](1);
			W1 = dptr->world_coordinates[j](2);
			W2 = dptr->world_coordinates[j](3);

			x[index] = ru(k0, k1, k2, k3, k4, thetax_X, thetay_X, thetaz_X, t0X, t1X, t2X,
					thetax_Z, thetay_Z, thetaz_Z, t0Z, t1Z, t2Z, W0, W1, W2, b0, b1, b2, b3, b4, b5,
					b6, b7, b8, b9, b10, b11, dist1, dist2, dist3, dist4, dist5, dist6, p1, p2, dptr->image_coordinates_x_y[index]);
			index++;
			x[index] = rv(k0, k1, k2, k3, k4, thetax_X, thetay_X, thetaz_X, t0X, t1X, t2X,
					thetax_Z, thetay_Z, thetaz_Z, t0Z, t1Z, t2Z, W0, W1, W2, b0, b1, b2, b3, b4, b5,
					b6, b7, b8, b9, b10, b11, dist1, dist2, dist3, dist4, dist5, dist6, p1, p2, dptr->image_coordinates_x_y[index]);
			index++;

		}
	}

	if (index != n){
		cout << "ERROR! " << index << ", " << n << endl;
		exit(1);
	}


	double val = 0;

	for (int i = 0; i < n; i++){
		val += x[i]*x[i];
	}

	cout << "Squared, summed reprojection error from residuals " << val << endl;
	//char ch; cin >> ch;
}

void residuals_reprojection3(double *p, double *x, int m, int n, void *data){

	// only different in between 2 and 3 is that the radial distortion items are parameters instead of constant arguments
	//	char ch;
	CaliData *dptr;

	dptr=(CaliData*)data;


	int index = 0;

	// get the current parameters ...

	double k0 = p[0];
	double k1 = p[1];
	double k2 = p[2];
	double k3 = p[3];
	double k4 = p[4];

	double thetax_X = p[5];
	double thetay_X = p[6];
	double thetaz_X = p[7];
	double t0X = p[8];
	double t1X = p[9];
	double t2X = p[10];

	double thetax_Z = p[11];
	double thetay_Z = p[12];
	double thetaz_Z = p[13];
	double t0Z = p[14];
	double t1Z = p[15];
	double t2Z = p[16];

	double dist1 =  p[17];
	double dist2 =  p[18];
	double p1 =  p[19];
	double p2 =  p[20];
	double dist3 =  p[21];
	double dist4 =  p[22];
	double dist5 =  p[23];
	double dist6 =  p[24];


	//double a0, a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11;
	double b0, b1, b2, b3, b4, b5, b6, b7, b8, b9, b10, b11;

	double W0, W1, W2;

	for (int i = 0; i < int(dptr->As->size()); i++){

		b0 = dptr->Bs->at(i)(1, 1);
		b1 = dptr->Bs->at(i)(1, 2);
		b2 = dptr->Bs->at(i)(1, 3);
		b3 = dptr->Bs->at(i)(1, 4);

		b4 = dptr->Bs->at(i)(2, 1);
		b5 = dptr->Bs->at(i)(2, 2);
		b6 = dptr->Bs->at(i)(2, 3);
		b7 = dptr->Bs->at(i)(2, 4);

		b8 = dptr->Bs->at(i)(3, 1);
		b9 = dptr->Bs->at(i)(3, 2);
		b10 = dptr->Bs->at(i)(3, 3);
		b11 = dptr->Bs->at(i)(3, 4);


		for (int j = 0; j < int(dptr->world_coordinates.size()); j++){

			W0 = dptr->world_coordinates[j](1);
			W1 = dptr->world_coordinates[j](2);
			W2 = dptr->world_coordinates[j](3);

			x[index] = ru(k0, k1, k2, k3, k4, thetax_X, thetay_X, thetaz_X, t0X, t1X, t2X,
					thetax_Z, thetay_Z, thetaz_Z, t0Z, t1Z, t2Z, W0, W1, W2, b0, b1, b2, b3, b4, b5,
					b6, b7, b8, b9, b10, b11, dist1, dist2, dist3, dist4, dist5, dist6, p1, p2, dptr->image_coordinates_x_y[index]);
			index++;
			x[index] = rv(k0, k1, k2, k3, k4, thetax_X, thetay_X, thetaz_X, t0X, t1X, t2X,
					thetax_Z, thetay_Z, thetaz_Z, t0Z, t1Z, t2Z, W0, W1, W2, b0, b1, b2, b3, b4, b5,
					b6, b7, b8, b9, b10, b11, dist1, dist2, dist3, dist4, dist5, dist6, p1, p2, dptr->image_coordinates_x_y[index]);
			index++;

		}
	}

	if (index != n){
		cout << "ERROR! " << index << ", " << n << endl;
		exit(1);
	}


	double val = 0;

	for (int i = 0; i < n; i++){
		val += x[i]*x[i];
	}

	cout << "Squared, summed reprojection error from residuals " << val << endl;
	//char ch; cin >> ch;
}


void jacobian_reprojection2(double *p, double *x, int m, int n, void *data){

	//	char ch;
	CaliData *dptr;

	dptr=(CaliData*)data;


	int index = 0;

	// get the current parameters ...

	double k0 = p[0];
	double k1 = p[1];
	double k2 = p[2];
	double k3 = p[3];
	double k4 = p[4];

	double thetax_X = p[5];
	double thetay_X = p[6];
	double thetaz_X = p[7];
	double t0X = p[8];
	double t1X = p[9];
	double t2X = p[10];

	double thetax_Z = p[11];
	double thetay_Z = p[12];
	double thetaz_Z = p[13];
	double t0Z = p[14];
	double t1Z = p[15];
	double t2Z = p[16];

	double dist1;
	double dist2;
	double dist3;
	double dist4;
	double dist5;
	double dist6;
	double p1;
	double p2;

	dist1 = dptr->CO->k[0];
	dist2 = dptr->CO->k[1];
	p1 = dptr->CO->k[2];
	p2 = dptr->CO->k[3];
	dist3 = dptr->CO->k[4];
	dist4 = dptr->CO->k[5];
	dist5 = dptr->CO->k[6];
	dist6 = dptr->CO->k[7];

	//double a0, a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11;
	double b0, b1, b2, b3, b4, b5, b6, b7, b8, b9, b10, b11;

	double W0, W1, W2;

	for (int i = 0; i < int(dptr->As->size()); i++){

		b0 = dptr->Bs->at(i)(1, 1);
		b1 = dptr->Bs->at(i)(1, 2);
		b2 = dptr->Bs->at(i)(1, 3);
		b3 = dptr->Bs->at(i)(1, 4);

		b4 = dptr->Bs->at(i)(2, 1);
		b5 = dptr->Bs->at(i)(2, 2);
		b6 = dptr->Bs->at(i)(2, 3);
		b7 = dptr->Bs->at(i)(2, 4);

		b8 = dptr->Bs->at(i)(3, 1);
		b9 = dptr->Bs->at(i)(3, 2);
		b10 = dptr->Bs->at(i)(3, 3);
		b11 = dptr->Bs->at(i)(3, 4);


		for (int j = 0; j < dptr->world_coordinates.size(); j++){

			W0 = dptr->world_coordinates[j](1);
			W1 = dptr->world_coordinates[j](2);
			W2 = dptr->world_coordinates[j](3);

			// skip first 5 -- cali parameters
			for (int p = 0; p < 5; p++){
				x[index] = 0; index++;
			}

			// du/dthetax_X
			x[index] = du_dthetax_X(k0, k1, k2, k3, k4, thetax_X, thetay_X, thetaz_X, t0X, t1X, t2X,
					thetax_Z, thetay_Z, thetaz_Z, t0Z, t1Z, t2Z, W0, W1, W2, b0, b1, b2, b3, b4, b5,
					b6, b7, b8, b9, b10, b11, dist1, dist2, dist3, dist4, dist5, dist6, p1, p2);
			index++;

			// du/dthetay_X
			x[index] = du_dthetay_X(k0, k1, k2, k3, k4, thetax_X, thetay_X, thetaz_X, t0X, t1X, t2X,
					thetax_Z, thetay_Z, thetaz_Z, t0Z, t1Z, t2Z, W0, W1, W2, b0, b1, b2, b3, b4, b5,
					b6, b7, b8, b9, b10, b11, dist1, dist2, dist3, dist4, dist5, dist6, p1, p2);;
			index++;

			// du/dthetaz_X
			x[index] = du_dthetaz_X(k0, k1, k2, k3, k4, thetax_X, thetay_X, thetaz_X, t0X, t1X, t2X,
					thetax_Z, thetay_Z, thetaz_Z, t0Z, t1Z, t2Z, W0, W1, W2, b0, b1, b2, b3, b4, b5,
					b6, b7, b8, b9, b10, b11, dist1, dist2, dist3, dist4, dist5, dist6, p1, p2);;;
			index++;

			// du/t0X
			x[index] = du_dt0X(k0, k1, k2, k3, k4, thetax_X, thetay_X, thetaz_X, t0X, t1X, t2X,
					thetax_Z, thetay_Z, thetaz_Z, t0Z, t1Z, t2Z, W0, W1, W2, b0, b1, b2, b3, b4, b5,
					b6, b7, b8, b9, b10, b11, dist1, dist2, dist3, dist4, dist5, dist6, p1, p2);;;
			index++;

			//du/dt1X
			//x[index] = 0;
			x[index] = du_dt1X(k0, k1, k2, k3, k4, thetax_X, thetay_X, thetaz_X, t0X, t1X, t2X,
					thetax_Z, thetay_Z, thetaz_Z, t0Z, t1Z, t2Z, W0, W1, W2, b0, b1, b2, b3, b4, b5,
					b6, b7, b8, b9, b10, b11, dist1, dist2, dist3, dist4, dist5, dist6, p1, p2);
			index++;

			//du/dt2X
			x[index] = du_dt2X(k0, k1, k2, k3, k4, thetax_X, thetay_X, thetaz_X, t0X, t1X, t2X,
					thetax_Z, thetay_Z, thetaz_Z, t0Z, t1Z, t2Z, W0, W1, W2, b0, b1, b2, b3, b4, b5,
					b6, b7, b8, b9, b10, b11, dist1, dist2, dist3, dist4, dist5, dist6, p1, p2);
			index++;

			// du/dthetax_Z
			x[index] =  du_dthetax_Z(k0, k1, k2, k3, k4, thetax_X, thetay_X, thetaz_X, t0X, t1X, t2X,
					thetax_Z, thetay_Z, thetaz_Z, t0Z, t1Z, t2Z, W0, W1, W2, b0, b1, b2, b3, b4, b5,
					b6, b7, b8, b9, b10, b11, dist1, dist2, dist3, dist4, dist5, dist6, p1, p2);;
			index++;

			// du/dthetay_Z
			x[index] = du_dthetay_Z(k0, k1, k2, k3, k4, thetax_X, thetay_X, thetaz_X, t0X, t1X, t2X,
					thetax_Z, thetay_Z, thetaz_Z, t0Z, t1Z, t2Z, W0, W1, W2, b0, b1, b2, b3, b4, b5,
					b6, b7, b8, b9, b10, b11, dist1, dist2, dist3, dist4, dist5, dist6, p1, p2);;
			index++;

			// du/dthetaz_Z
			x[index] = du_dthetaz_Z(k0, k1, k2, k3, k4, thetax_X, thetay_X, thetaz_X, t0X, t1X, t2X,
					thetax_Z, thetay_Z, thetaz_Z, t0Z, t1Z, t2Z, W0, W1, W2, b0, b1, b2, b3, b4, b5,
					b6, b7, b8, b9, b10, b11, dist1, dist2, dist3, dist4, dist5, dist6, p1, p2);;
			index++;

			// du/t0Z
			x[index] = du_dt0Z(k0, k1, k2, k3, k4, thetax_X, thetay_X, thetaz_X, t0X, t1X, t2X,
					thetax_Z, thetay_Z, thetaz_Z, t0Z, t1Z, t2Z, W0, W1, W2, b0, b1, b2, b3, b4, b5,
					b6, b7, b8, b9, b10, b11, dist1, dist2, dist3, dist4, dist5, dist6, p1, p2);;
			index++;

			//du/dt1Z
			x[index] = du_dt1Z(k0, k1, k2, k3, k4, thetax_X, thetay_X, thetaz_X, t0X, t1X, t2X,
					thetax_Z, thetay_Z, thetaz_Z, t0Z, t1Z, t2Z, W0, W1, W2, b0, b1, b2, b3, b4, b5,
					b6, b7, b8, b9, b10, b11, dist1, dist2, dist3, dist4, dist5, dist6, p1, p2);;
			index++;

			//du/dt2Z
			x[index] = du_dt2Z(k0, k1, k2, k3, k4, thetax_X, thetay_X, thetaz_X, t0X, t1X, t2X,
					thetax_Z, thetay_Z, thetaz_Z, t0Z, t1Z, t2Z, W0, W1, W2, b0, b1, b2, b3, b4, b5,
					b6, b7, b8, b9, b10, b11, dist1, dist2, dist3, dist4, dist5, dist6, p1, p2);;
			index++;

			//////////////////////////////////////////////////////////////////////
			// skip first 5 -- cali parameters
			for (int p = 0; p < 5; p++){
				x[index] = 0; index++;
			}

			// dv/dthetax_X
			x[index] = dv_dthetax_X(k0, k1, k2, k3, k4, thetax_X, thetay_X, thetaz_X, t0X, t1X, t2X,
					thetax_Z, thetay_Z, thetaz_Z, t0Z, t1Z, t2Z, W0, W1, W2, b0, b1, b2, b3, b4, b5,
					b6, b7, b8, b9, b10, b11, dist1, dist2, dist3, dist4, dist5, dist6, p1, p2);
			index++;

			// dv/dthetay_X
			x[index] = dv_dthetay_X(k0, k1, k2, k3, k4, thetax_X, thetay_X, thetaz_X, t0X, t1X, t2X,
					thetax_Z, thetay_Z, thetaz_Z, t0Z, t1Z, t2Z, W0, W1, W2, b0, b1, b2, b3, b4, b5,
					b6, b7, b8, b9, b10, b11, dist1, dist2, dist3, dist4, dist5, dist6, p1, p2);;
			index++;

			// dv/dthetaz_X
			x[index] = dv_dthetaz_X(k0, k1, k2, k3, k4, thetax_X, thetay_X, thetaz_X, t0X, t1X, t2X,
					thetax_Z, thetay_Z, thetaz_Z, t0Z, t1Z, t2Z, W0, W1, W2, b0, b1, b2, b3, b4, b5,
					b6, b7, b8, b9, b10, b11, dist1, dist2, dist3, dist4, dist5, dist6, p1, p2);;;
			index++;

			// dv/t0X
			x[index] = dv_dt0X(k0, k1, k2, k3, k4, thetax_X, thetay_X, thetaz_X, t0X, t1X, t2X,
					thetax_Z, thetay_Z, thetaz_Z, t0Z, t1Z, t2Z, W0, W1, W2, b0, b1, b2, b3, b4, b5,
					b6, b7, b8, b9, b10, b11, dist1, dist2, dist3, dist4, dist5, dist6, p1, p2);;;
			index++;

			//dv/dt1X
			//x[index] = 0;
			x[index] = dv_dt1X(k0, k1, k2, k3, k4, thetax_X, thetay_X, thetaz_X, t0X, t1X, t2X,
					thetax_Z, thetay_Z, thetaz_Z, t0Z, t1Z, t2Z, W0, W1, W2, b0, b1, b2, b3, b4, b5,
					b6, b7, b8, b9, b10, b11, dist1, dist2, dist3, dist4, dist5, dist6, p1, p2);;;
			index++;

			//dv/dt2X
			x[index] = dv_dt2X(k0, k1, k2, k3, k4, thetax_X, thetay_X, thetaz_X, t0X, t1X, t2X,
					thetax_Z, thetay_Z, thetaz_Z, t0Z, t1Z, t2Z, W0, W1, W2, b0, b1, b2, b3, b4, b5,
					b6, b7, b8, b9, b10, b11, dist1, dist2, dist3, dist4, dist5, dist6, p1, p2);;;
			index++;

			// dv/dthetax_Z
			x[index] = dv_dthetax_Z(k0, k1, k2, k3, k4, thetax_X, thetay_X, thetaz_X, t0X, t1X, t2X,
					thetax_Z, thetay_Z, thetaz_Z, t0Z, t1Z, t2Z, W0, W1, W2, b0, b1, b2, b3, b4, b5,
					b6, b7, b8, b9, b10, b11, dist1, dist2, dist3, dist4, dist5, dist6, p1, p2);
			index++;

			// dv/dthetay_Z
			x[index] = dv_dthetay_Z(k0, k1, k2, k3, k4, thetax_X, thetay_X, thetaz_X, t0X, t1X, t2X,
					thetax_Z, thetay_Z, thetaz_Z, t0Z, t1Z, t2Z, W0, W1, W2, b0, b1, b2, b3, b4, b5,
					b6, b7, b8, b9, b10, b11, dist1, dist2, dist3, dist4, dist5, dist6, p1, p2);
			index++;

			// dv/dthetaz_Z
			x[index] = dv_dthetaz_Z(k0, k1, k2, k3, k4, thetax_X, thetay_X, thetaz_X, t0X, t1X, t2X,
					thetax_Z, thetay_Z, thetaz_Z, t0Z, t1Z, t2Z, W0, W1, W2, b0, b1, b2, b3, b4, b5,
					b6, b7, b8, b9, b10, b11, dist1, dist2, dist3, dist4, dist5, dist6, p1, p2);
			index++;

			// dv/t0Z
			x[index] = dv_dt0Z(k0, k1, k2, k3, k4, thetax_X, thetay_X, thetaz_X, t0X, t1X, t2X,
					thetax_Z, thetay_Z, thetaz_Z, t0Z, t1Z, t2Z, W0, W1, W2, b0, b1, b2, b3, b4, b5,
					b6, b7, b8, b9, b10, b11, dist1, dist2, dist3, dist4, dist5, dist6, p1, p2);
			index++;

			//dv/dt1Z
			x[index] = dv_dt1Z(k0, k1, k2, k3, k4, thetax_X, thetay_X, thetaz_X, t0X, t1X, t2X,
					thetax_Z, thetay_Z, thetaz_Z, t0Z, t1Z, t2Z, W0, W1, W2, b0, b1, b2, b3, b4, b5,
					b6, b7, b8, b9, b10, b11, dist1, dist2, dist3, dist4, dist5, dist6, p1, p2);;
			index++;

			//dv/dt2Z
			x[index] = dv_dt2Z(k0, k1, k2, k3, k4, thetax_X, thetay_X, thetaz_X, t0X, t1X, t2X,
					thetax_Z, thetay_Z, thetaz_Z, t0Z, t1Z, t2Z, W0, W1, W2, b0, b1, b2, b3, b4, b5,
					b6, b7, b8, b9, b10, b11, dist1, dist2, dist3, dist4, dist5, dist6, p1, p2);;
			index++;

		}
	}

	if (index != m*n){
		cout << "ERROR! " << index << " " << m*n << endl;
		exit(1);
	}

}

void jacobian_reprojection3(double *p, double *x, int m, int n, void *data){

	//	char ch;
	CaliData *dptr;

	dptr=(CaliData*)data;


	int index = 0;

	// get the current parameters ...

	double k0 = p[0];
	double k1 = p[1];
	double k2 = p[2];
	double k3 = p[3];
	double k4 = p[4];

	double thetax_X = p[5];
	double thetay_X = p[6];
	double thetaz_X = p[7];
	double t0X = p[8];
	double t1X = p[9];
	double t2X = p[10];

	double thetax_Z = p[11];
	double thetay_Z = p[12];
	double thetaz_Z = p[13];
	double t0Z = p[14];
	double t1Z = p[15];
	double t2Z = p[16];

	double dist1 =  p[17];
	double dist2 =  p[18];
	double p1 =  p[19];
	double p2 =  p[20];
	double dist3 =  p[21];
	double dist4 =  p[22];
	double dist5 =  p[23];
	double dist6 =  p[24];

	//double a0, a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11;
	double b0, b1, b2, b3, b4, b5, b6, b7, b8, b9, b10, b11;

	double W0, W1, W2;

	for (int i = 0; i < int(dptr->As->size()); i++){

		b0 = dptr->Bs->at(i)(1, 1);
		b1 = dptr->Bs->at(i)(1, 2);
		b2 = dptr->Bs->at(i)(1, 3);
		b3 = dptr->Bs->at(i)(1, 4);

		b4 = dptr->Bs->at(i)(2, 1);
		b5 = dptr->Bs->at(i)(2, 2);
		b6 = dptr->Bs->at(i)(2, 3);
		b7 = dptr->Bs->at(i)(2, 4);

		b8 = dptr->Bs->at(i)(3, 1);
		b9 = dptr->Bs->at(i)(3, 2);
		b10 = dptr->Bs->at(i)(3, 3);
		b11 = dptr->Bs->at(i)(3, 4);


		for (int j = 0; j < dptr->world_coordinates.size(); j++){

			W0 = dptr->world_coordinates[j](1);
			W1 = dptr->world_coordinates[j](2);
			W2 = dptr->world_coordinates[j](3);

			//du/dk0
			x[index] = du_dk0(k0, k1, k2, k3, k4, thetax_X, thetay_X, thetaz_X, t0X, t1X, t2X,
					thetax_Z, thetay_Z, thetaz_Z, t0Z, t1Z, t2Z, W0, W1, W2, b0, b1, b2, b3, b4, b5,
					b6, b7, b8, b9, b10, b11, dist1, dist2, dist3, dist4, dist5, dist6, p1, p2);
			index++;

			//du/dk1 -- not valid for this model ....
			x[index] = 0;
			index++;

			//du/dk2
			x[index] = du_dk2(k0, k1, k2, k3, k4, thetax_X, thetay_X, thetaz_X, t0X, t1X, t2X,
					thetax_Z, thetay_Z, thetaz_Z, t0Z, t1Z, t2Z, W0, W1, W2, b0, b1, b2, b3, b4, b5,
					b6, b7, b8, b9, b10, b11, dist1, dist2, dist3, dist4, dist5, dist6, p1, p2);
			index++;

			//du/dk3
			x[index] = du_dk3(k0, k1, k2, k3, k4, thetax_X, thetay_X, thetaz_X, t0X, t1X, t2X,
					thetax_Z, thetay_Z, thetaz_Z, t0Z, t1Z, t2Z, W0, W1, W2, b0, b1, b2, b3, b4, b5,
					b6, b7, b8, b9, b10, b11, dist1, dist2, dist3, dist4, dist5, dist6, p1, p2);
			index++;

			//du/dk4
			x[index] = du_dk4(k0, k1, k2, k3, k4, thetax_X, thetay_X, thetaz_X, t0X, t1X, t2X,
					thetax_Z, thetay_Z, thetaz_Z, t0Z, t1Z, t2Z, W0, W1, W2, b0, b1, b2, b3, b4, b5,
					b6, b7, b8, b9, b10, b11, dist1, dist2, dist3, dist4, dist5, dist6, p1, p2);
			index++;

			// RWHE parameters     //////////////////////////////////////////////////////////
			// du/dthetax_X
			x[index] = du_dthetax_X(k0, k1, k2, k3, k4, thetax_X, thetay_X, thetaz_X, t0X, t1X, t2X,
					thetax_Z, thetay_Z, thetaz_Z, t0Z, t1Z, t2Z, W0, W1, W2, b0, b1, b2, b3, b4, b5,
					b6, b7, b8, b9, b10, b11, dist1, dist2, dist3, dist4, dist5, dist6, p1, p2);
			index++;

			// du/dthetay_X
			x[index] = du_dthetay_X(k0, k1, k2, k3, k4, thetax_X, thetay_X, thetaz_X, t0X, t1X, t2X,
					thetax_Z, thetay_Z, thetaz_Z, t0Z, t1Z, t2Z, W0, W1, W2, b0, b1, b2, b3, b4, b5,
					b6, b7, b8, b9, b10, b11, dist1, dist2, dist3, dist4, dist5, dist6, p1, p2);;
			index++;

			// du/dthetaz_X
			x[index] = du_dthetaz_X(k0, k1, k2, k3, k4, thetax_X, thetay_X, thetaz_X, t0X, t1X, t2X,
					thetax_Z, thetay_Z, thetaz_Z, t0Z, t1Z, t2Z, W0, W1, W2, b0, b1, b2, b3, b4, b5,
					b6, b7, b8, b9, b10, b11, dist1, dist2, dist3, dist4, dist5, dist6, p1, p2);;;
			index++;

			// du/t0X
			x[index] = du_dt0X(k0, k1, k2, k3, k4, thetax_X, thetay_X, thetaz_X, t0X, t1X, t2X,
					thetax_Z, thetay_Z, thetaz_Z, t0Z, t1Z, t2Z, W0, W1, W2, b0, b1, b2, b3, b4, b5,
					b6, b7, b8, b9, b10, b11, dist1, dist2, dist3, dist4, dist5, dist6, p1, p2);;;
			index++;

			//du/dt1X
			//x[index] = 0;
			x[index] = du_dt1X(k0, k1, k2, k3, k4, thetax_X, thetay_X, thetaz_X, t0X, t1X, t2X,
					thetax_Z, thetay_Z, thetaz_Z, t0Z, t1Z, t2Z, W0, W1, W2, b0, b1, b2, b3, b4, b5,
					b6, b7, b8, b9, b10, b11, dist1, dist2, dist3, dist4, dist5, dist6, p1, p2);
			index++;

			//du/dt2X
			x[index] = du_dt2X(k0, k1, k2, k3, k4, thetax_X, thetay_X, thetaz_X, t0X, t1X, t2X,
					thetax_Z, thetay_Z, thetaz_Z, t0Z, t1Z, t2Z, W0, W1, W2, b0, b1, b2, b3, b4, b5,
					b6, b7, b8, b9, b10, b11, dist1, dist2, dist3, dist4, dist5, dist6, p1, p2);
			index++;

			// du/dthetax_Z
			x[index] =  du_dthetax_Z(k0, k1, k2, k3, k4, thetax_X, thetay_X, thetaz_X, t0X, t1X, t2X,
					thetax_Z, thetay_Z, thetaz_Z, t0Z, t1Z, t2Z, W0, W1, W2, b0, b1, b2, b3, b4, b5,
					b6, b7, b8, b9, b10, b11, dist1, dist2, dist3, dist4, dist5, dist6, p1, p2);;
			index++;

			// du/dthetay_Z
			x[index] = du_dthetay_Z(k0, k1, k2, k3, k4, thetax_X, thetay_X, thetaz_X, t0X, t1X, t2X,
					thetax_Z, thetay_Z, thetaz_Z, t0Z, t1Z, t2Z, W0, W1, W2, b0, b1, b2, b3, b4, b5,
					b6, b7, b8, b9, b10, b11, dist1, dist2, dist3, dist4, dist5, dist6, p1, p2);;
			index++;

			// du/dthetaz_Z
			x[index] = du_dthetaz_Z(k0, k1, k2, k3, k4, thetax_X, thetay_X, thetaz_X, t0X, t1X, t2X,
					thetax_Z, thetay_Z, thetaz_Z, t0Z, t1Z, t2Z, W0, W1, W2, b0, b1, b2, b3, b4, b5,
					b6, b7, b8, b9, b10, b11, dist1, dist2, dist3, dist4, dist5, dist6, p1, p2);;
			index++;

			// du/t0Z
			x[index] = du_dt0Z(k0, k1, k2, k3, k4, thetax_X, thetay_X, thetaz_X, t0X, t1X, t2X,
					thetax_Z, thetay_Z, thetaz_Z, t0Z, t1Z, t2Z, W0, W1, W2, b0, b1, b2, b3, b4, b5,
					b6, b7, b8, b9, b10, b11, dist1, dist2, dist3, dist4, dist5, dist6, p1, p2);;
			index++;

			//du/dt1Z
			x[index] = du_dt1Z(k0, k1, k2, k3, k4, thetax_X, thetay_X, thetaz_X, t0X, t1X, t2X,
					thetax_Z, thetay_Z, thetaz_Z, t0Z, t1Z, t2Z, W0, W1, W2, b0, b1, b2, b3, b4, b5,
					b6, b7, b8, b9, b10, b11, dist1, dist2, dist3, dist4, dist5, dist6, p1, p2);;
			index++;

			//du/dt2Z
			x[index] = du_dt2Z(k0, k1, k2, k3, k4, thetax_X, thetay_X, thetaz_X, t0X, t1X, t2X,
					thetax_Z, thetay_Z, thetaz_Z, t0Z, t1Z, t2Z, W0, W1, W2, b0, b1, b2, b3, b4, b5,
					b6, b7, b8, b9, b10, b11, dist1, dist2, dist3, dist4, dist5, dist6, p1, p2);;
			index++;


			// 8 distortion parameters ....
			//du/ddist1
			x[index] = du_ddist1(k0, k1, k2, k3, k4, thetax_X, thetay_X, thetaz_X, t0X, t1X, t2X,
					thetax_Z, thetay_Z, thetaz_Z, t0Z, t1Z, t2Z, W0, W1, W2, b0, b1, b2, b3, b4, b5,
					b6, b7, b8, b9, b10, b11, dist1, dist2, dist3, dist4, dist5, dist6, p1, p2);;
			index++;

			//du/ddist2
			x[index] = du_ddist2(k0, k1, k2, k3, k4, thetax_X, thetay_X, thetaz_X, t0X, t1X, t2X,
					thetax_Z, thetay_Z, thetaz_Z, t0Z, t1Z, t2Z, W0, W1, W2, b0, b1, b2, b3, b4, b5,
					b6, b7, b8, b9, b10, b11, dist1, dist2, dist3, dist4, dist5, dist6, p1, p2);
			index++;

			//du/dp1
			x[index] = du_dp1(k0, k1, k2, k3, k4, thetax_X, thetay_X, thetaz_X, t0X, t1X, t2X,
					thetax_Z, thetay_Z, thetaz_Z, t0Z, t1Z, t2Z, W0, W1, W2, b0, b1, b2, b3, b4, b5,
					b6, b7, b8, b9, b10, b11, dist1, dist2, dist3, dist4, dist5, dist6, p1, p2);;
			index++;

			//du/dp2
			x[index] = du_dp2(k0, k1, k2, k3, k4, thetax_X, thetay_X, thetaz_X, t0X, t1X, t2X,
					thetax_Z, thetay_Z, thetaz_Z, t0Z, t1Z, t2Z, W0, W1, W2, b0, b1, b2, b3, b4, b5,
					b6, b7, b8, b9, b10, b11, dist1, dist2, dist3, dist4, dist5, dist6, p1, p2);
			index++;

			//du/ddist3
			x[index] = du_ddist3(k0, k1, k2, k3, k4, thetax_X, thetay_X, thetaz_X, t0X, t1X, t2X,
					thetax_Z, thetay_Z, thetaz_Z, t0Z, t1Z, t2Z, W0, W1, W2, b0, b1, b2, b3, b4, b5,
					b6, b7, b8, b9, b10, b11, dist1, dist2, dist3, dist4, dist5, dist6, p1, p2);;
			index++;

			//du/ddist4
			x[index] = du_ddist4(k0, k1, k2, k3, k4, thetax_X, thetay_X, thetaz_X, t0X, t1X, t2X,
					thetax_Z, thetay_Z, thetaz_Z, t0Z, t1Z, t2Z, W0, W1, W2, b0, b1, b2, b3, b4, b5,
					b6, b7, b8, b9, b10, b11, dist1, dist2, dist3, dist4, dist5, dist6, p1, p2);
			index++;

			//du/ddist5
			x[index] = du_ddist5(k0, k1, k2, k3, k4, thetax_X, thetay_X, thetaz_X, t0X, t1X, t2X,
					thetax_Z, thetay_Z, thetaz_Z, t0Z, t1Z, t2Z, W0, W1, W2, b0, b1, b2, b3, b4, b5,
					b6, b7, b8, b9, b10, b11, dist1, dist2, dist3, dist4, dist5, dist6, p1, p2);;
			index++;

			//du/ddist6
			x[index] = du_ddist6(k0, k1, k2, k3, k4, thetax_X, thetay_X, thetaz_X, t0X, t1X, t2X,
					thetax_Z, thetay_Z, thetaz_Z, t0Z, t1Z, t2Z, W0, W1, W2, b0, b1, b2, b3, b4, b5,
					b6, b7, b8, b9, b10, b11, dist1, dist2, dist3, dist4, dist5, dist6, p1, p2);
			index++;


			//dv/dk0
			x[index] = dv_dk0(k0, k1, k2, k3, k4, thetax_X, thetay_X, thetaz_X, t0X, t1X, t2X,
					thetax_Z, thetay_Z, thetaz_Z, t0Z, t1Z, t2Z, W0, W1, W2, b0, b1, b2, b3, b4, b5,
					b6, b7, b8, b9, b10, b11, dist1, dist2, dist3, dist4, dist5, dist6, p1, p2);
			index++;

			//dv/dk1 -- not valid for this model ....
			x[index] = 0;
			index++;

			//dv/dk2
			x[index] = dv_dk2(k0, k1, k2, k3, k4, thetax_X, thetay_X, thetaz_X, t0X, t1X, t2X,
					thetax_Z, thetay_Z, thetaz_Z, t0Z, t1Z, t2Z, W0, W1, W2, b0, b1, b2, b3, b4, b5,
					b6, b7, b8, b9, b10, b11, dist1, dist2, dist3, dist4, dist5, dist6, p1, p2);
			index++;

			//dv/dk3
			x[index] = dv_dk3(k0, k1, k2, k3, k4, thetax_X, thetay_X, thetaz_X, t0X, t1X, t2X,
					thetax_Z, thetay_Z, thetaz_Z, t0Z, t1Z, t2Z, W0, W1, W2, b0, b1, b2, b3, b4, b5,
					b6, b7, b8, b9, b10, b11, dist1, dist2, dist3, dist4, dist5, dist6, p1, p2);
			index++;

			//dv/dk4
			x[index] = dv_dk4(k0, k1, k2, k3, k4, thetax_X, thetay_X, thetaz_X, t0X, t1X, t2X,
					thetax_Z, thetay_Z, thetaz_Z, t0Z, t1Z, t2Z, W0, W1, W2, b0, b1, b2, b3, b4, b5,
					b6, b7, b8, b9, b10, b11, dist1, dist2, dist3, dist4, dist5, dist6, p1, p2);
			index++;

			// RWHE parameters     //////////////////////////////////////////////////////////
			// dv/dthetax_X
			x[index] = dv_dthetax_X(k0, k1, k2, k3, k4, thetax_X, thetay_X, thetaz_X, t0X, t1X, t2X,
					thetax_Z, thetay_Z, thetaz_Z, t0Z, t1Z, t2Z, W0, W1, W2, b0, b1, b2, b3, b4, b5,
					b6, b7, b8, b9, b10, b11, dist1, dist2, dist3, dist4, dist5, dist6, p1, p2);
			index++;

			// dv/dthetay_X
			x[index] = dv_dthetay_X(k0, k1, k2, k3, k4, thetax_X, thetay_X, thetaz_X, t0X, t1X, t2X,
					thetax_Z, thetay_Z, thetaz_Z, t0Z, t1Z, t2Z, W0, W1, W2, b0, b1, b2, b3, b4, b5,
					b6, b7, b8, b9, b10, b11, dist1, dist2, dist3, dist4, dist5, dist6, p1, p2);;
			index++;

			// dv/dthetaz_X
			x[index] = dv_dthetaz_X(k0, k1, k2, k3, k4, thetax_X, thetay_X, thetaz_X, t0X, t1X, t2X,
					thetax_Z, thetay_Z, thetaz_Z, t0Z, t1Z, t2Z, W0, W1, W2, b0, b1, b2, b3, b4, b5,
					b6, b7, b8, b9, b10, b11, dist1, dist2, dist3, dist4, dist5, dist6, p1, p2);;;
			index++;

			// dv/t0X
			x[index] = dv_dt0X(k0, k1, k2, k3, k4, thetax_X, thetay_X, thetaz_X, t0X, t1X, t2X,
					thetax_Z, thetay_Z, thetaz_Z, t0Z, t1Z, t2Z, W0, W1, W2, b0, b1, b2, b3, b4, b5,
					b6, b7, b8, b9, b10, b11, dist1, dist2, dist3, dist4, dist5, dist6, p1, p2);;;
			index++;

			//dv/dt1X
			//x[index] = 0;
			x[index] = dv_dt1X(k0, k1, k2, k3, k4, thetax_X, thetay_X, thetaz_X, t0X, t1X, t2X,
					thetax_Z, thetay_Z, thetaz_Z, t0Z, t1Z, t2Z, W0, W1, W2, b0, b1, b2, b3, b4, b5,
					b6, b7, b8, b9, b10, b11, dist1, dist2, dist3, dist4, dist5, dist6, p1, p2);;;
			index++;

			//dv/dt2X
			x[index] = dv_dt2X(k0, k1, k2, k3, k4, thetax_X, thetay_X, thetaz_X, t0X, t1X, t2X,
					thetax_Z, thetay_Z, thetaz_Z, t0Z, t1Z, t2Z, W0, W1, W2, b0, b1, b2, b3, b4, b5,
					b6, b7, b8, b9, b10, b11, dist1, dist2, dist3, dist4, dist5, dist6, p1, p2);;;
			index++;

			// dv/dthetax_Z
			x[index] = dv_dthetax_Z(k0, k1, k2, k3, k4, thetax_X, thetay_X, thetaz_X, t0X, t1X, t2X,
					thetax_Z, thetay_Z, thetaz_Z, t0Z, t1Z, t2Z, W0, W1, W2, b0, b1, b2, b3, b4, b5,
					b6, b7, b8, b9, b10, b11, dist1, dist2, dist3, dist4, dist5, dist6, p1, p2);
			index++;

			// dv/dthetay_Z
			x[index] = dv_dthetay_Z(k0, k1, k2, k3, k4, thetax_X, thetay_X, thetaz_X, t0X, t1X, t2X,
					thetax_Z, thetay_Z, thetaz_Z, t0Z, t1Z, t2Z, W0, W1, W2, b0, b1, b2, b3, b4, b5,
					b6, b7, b8, b9, b10, b11, dist1, dist2, dist3, dist4, dist5, dist6, p1, p2);
			index++;

			// dv/dthetaz_Z
			x[index] = dv_dthetaz_Z(k0, k1, k2, k3, k4, thetax_X, thetay_X, thetaz_X, t0X, t1X, t2X,
					thetax_Z, thetay_Z, thetaz_Z, t0Z, t1Z, t2Z, W0, W1, W2, b0, b1, b2, b3, b4, b5,
					b6, b7, b8, b9, b10, b11, dist1, dist2, dist3, dist4, dist5, dist6, p1, p2);
			index++;

			// dv/t0Z
			x[index] = dv_dt0Z(k0, k1, k2, k3, k4, thetax_X, thetay_X, thetaz_X, t0X, t1X, t2X,
					thetax_Z, thetay_Z, thetaz_Z, t0Z, t1Z, t2Z, W0, W1, W2, b0, b1, b2, b3, b4, b5,
					b6, b7, b8, b9, b10, b11, dist1, dist2, dist3, dist4, dist5, dist6, p1, p2);
			index++;

			//dv/dt1Z
			x[index] = dv_dt1Z(k0, k1, k2, k3, k4, thetax_X, thetay_X, thetaz_X, t0X, t1X, t2X,
					thetax_Z, thetay_Z, thetaz_Z, t0Z, t1Z, t2Z, W0, W1, W2, b0, b1, b2, b3, b4, b5,
					b6, b7, b8, b9, b10, b11, dist1, dist2, dist3, dist4, dist5, dist6, p1, p2);;
			index++;

			//dv/dt2Z
			x[index] = dv_dt2Z(k0, k1, k2, k3, k4, thetax_X, thetay_X, thetaz_X, t0X, t1X, t2X,
					thetax_Z, thetay_Z, thetaz_Z, t0Z, t1Z, t2Z, W0, W1, W2, b0, b1, b2, b3, b4, b5,
					b6, b7, b8, b9, b10, b11, dist1, dist2, dist3, dist4, dist5, dist6, p1, p2);;
			index++;

			// 8 distortion parameters ....
			//dv/ddist1
			x[index] = dv_ddist1(k0, k1, k2, k3, k4, thetax_X, thetay_X, thetaz_X, t0X, t1X, t2X,
					thetax_Z, thetay_Z, thetaz_Z, t0Z, t1Z, t2Z, W0, W1, W2, b0, b1, b2, b3, b4, b5,
					b6, b7, b8, b9, b10, b11, dist1, dist2, dist3, dist4, dist5, dist6, p1, p2);;
			index++;

			//dv/ddist2
			x[index] = dv_ddist2(k0, k1, k2, k3, k4, thetax_X, thetay_X, thetaz_X, t0X, t1X, t2X,
					thetax_Z, thetay_Z, thetaz_Z, t0Z, t1Z, t2Z, W0, W1, W2, b0, b1, b2, b3, b4, b5,
					b6, b7, b8, b9, b10, b11, dist1, dist2, dist3, dist4, dist5, dist6, p1, p2);
			index++;

			//dv/dp1
			x[index] = dv_dp1(k0, k1, k2, k3, k4, thetax_X, thetay_X, thetaz_X, t0X, t1X, t2X,
					thetax_Z, thetay_Z, thetaz_Z, t0Z, t1Z, t2Z, W0, W1, W2, b0, b1, b2, b3, b4, b5,
					b6, b7, b8, b9, b10, b11, dist1, dist2, dist3, dist4, dist5, dist6, p1, p2);;
			index++;

			//dv/dp2
			x[index] = dv_dp2(k0, k1, k2, k3, k4, thetax_X, thetay_X, thetaz_X, t0X, t1X, t2X,
					thetax_Z, thetay_Z, thetaz_Z, t0Z, t1Z, t2Z, W0, W1, W2, b0, b1, b2, b3, b4, b5,
					b6, b7, b8, b9, b10, b11, dist1, dist2, dist3, dist4, dist5, dist6, p1, p2);
			index++;

			//dv/ddist3
			x[index] = dv_ddist3(k0, k1, k2, k3, k4, thetax_X, thetay_X, thetaz_X, t0X, t1X, t2X,
					thetax_Z, thetay_Z, thetaz_Z, t0Z, t1Z, t2Z, W0, W1, W2, b0, b1, b2, b3, b4, b5,
					b6, b7, b8, b9, b10, b11, dist1, dist2, dist3, dist4, dist5, dist6, p1, p2);;
			index++;

			//dv/ddist4
			x[index] = dv_ddist4(k0, k1, k2, k3, k4, thetax_X, thetay_X, thetaz_X, t0X, t1X, t2X,
					thetax_Z, thetay_Z, thetaz_Z, t0Z, t1Z, t2Z, W0, W1, W2, b0, b1, b2, b3, b4, b5,
					b6, b7, b8, b9, b10, b11, dist1, dist2, dist3, dist4, dist5, dist6, p1, p2);
			index++;

			//dv/ddist5
			x[index] = dv_ddist5(k0, k1, k2, k3, k4, thetax_X, thetay_X, thetaz_X, t0X, t1X, t2X,
					thetax_Z, thetay_Z, thetaz_Z, t0Z, t1Z, t2Z, W0, W1, W2, b0, b1, b2, b3, b4, b5,
					b6, b7, b8, b9, b10, b11, dist1, dist2, dist3, dist4, dist5, dist6, p1, p2);;
			index++;

			//dv/ddist6
			x[index] = dv_ddist6(k0, k1, k2, k3, k4, thetax_X, thetay_X, thetaz_X, t0X, t1X, t2X,
					thetax_Z, thetay_Z, thetaz_Z, t0Z, t1Z, t2Z, W0, W1, W2, b0, b1, b2, b3, b4, b5,
					b6, b7, b8, b9, b10, b11, dist1, dist2, dist3, dist4, dist5, dist6, p1, p2);
			index++;

		}
	}

	if (index != m*n){
		cout << "ERROR! " << index << " " << m*n << endl;
		exit(1);
	}
}

void ExtractAnglesAndTransformAgain(Matrix& Rt, vector<double>& angles){

	//cout << "Rt first " << endl << Rt << endl;

	double thetax, thetay, thetaz;

	cout << Rt << endl;
	thetay = asin(Rt(1, 3));

	cout << "theta y " << thetay << endl;;
	//thetay *= -1;
	// two cases -- one where cos thetay is zero, and one when non zero
	if (fabs(cos(thetay)) > 0.0001){

		thetax = atan2(-Rt(2, 3)/cos(thetay), Rt(3, 3)/cos(thetay) );

		thetaz = atan2(-Rt(1, 2)/cos(thetay), Rt(1, 1)/cos(thetay) );

		cout << "thetax " << thetax << endl;
		cout << "thetaz " << thetaz << endl;


	}	else {
		cout << "NEED TO DO OTHER CASE " << endl;
		exit(1);
	}

	Matrix Rx(3, 3);
	Matrix Ry(3, 3);
	Matrix Rz(3, 3);



	Rx.Row(1) << 1 <<  0 << 0;
	Rx.Row(2) << 0 << cos(thetax) << -sin(thetax);
	Rx.Row(3) << 0 << sin(thetax) << cos(thetax);

	Ry.Row(1) << cos(thetay) << 0 << sin(thetay);
	Ry.Row(2) << 0 << 1 << 0;
	Ry.Row(3) << -sin(thetay) << 0 << cos(thetay);

	Rz.Row(1) << cos(thetaz) << -sin(thetaz) << 0;
	Rz.Row(2) << sin(thetaz) << cos(thetaz) << 0;
	Rz.Row(3) << 0 << 0 << 1;

	Matrix R(3, 3);
	R = Rx*Ry*Rz;

	cout << "New R " << endl << R << endl;
	//cout << "Diff " << endl << R - Rt.SubMatrix(1, 3, 1, 3) << endl;

	angles[0] = thetax;
	angles[1] = thetay;
	angles[2] = thetaz;
	//cin >> fg;
}

void LevMarMethodWithAngles(vector<Matrix>& As, vector<Matrix>& Bs, Matrix& X, Matrix& Z, std::ofstream& out){

	char ch;

	CaliData C;
	C.As = &As;
	C.Bs = &Bs;

	// each matrix has 12 elements
	int n = As.size()*12;
	int m = 12;   // 3 angles each, then 3 translation compoenents each.

	double x[n];

	//double jac[n*m];

	double opts[LM_OPTS_SZ], info[LM_INFO_SZ];

	opts[0]=LM_INIT_MU; opts[1]=1E-15; opts[2]=1E-15; opts[3]=1E-20;
	opts[4]= LM_DIFF_DELTA; // relevant only if the Jacobian is approximated using finite differences; specifies forward differencing

	for (int i = 0; i < n; i++){
		x[i] = 0;
	}


	// convert X, Z, into parameter vector -- LATER

	double parameter_vector[12];
	for (int i = 0; i < m; i++){
		parameter_vector[i] = 0;
	}

	vector<double> anglesX(3, 0);

	ExtractAnglesAndTransformAgain(X, anglesX);

	parameter_vector[0] = anglesX[0];
	parameter_vector[1] = anglesX[1];
	parameter_vector[2] = anglesX[2];

	parameter_vector[3] = X(1, 4);
	parameter_vector[4] = X(2, 4);
	parameter_vector[5] = X(3, 4);

	ExtractAnglesAndTransformAgain(Z, anglesX);

	parameter_vector[6] = anglesX[0];
	parameter_vector[7] = anglesX[1];
	parameter_vector[8] = anglesX[2];

	parameter_vector[9] = Z(1, 4);
	parameter_vector[10] = Z(2, 4);
	parameter_vector[11] = Z(3, 4);

	out << endl;
	out << "Intial solution ";
	for(int i=0; i<m; ++i){
		out <<	parameter_vector[i] << " ";
	}
	out << endl << endl;

	//int ret;
	int ret = dlevmar_der(residuals_euler1, jacobian_euler1, parameter_vector, x, m, n, 1000, opts, info, NULL, NULL, &C); // with analytic Jacobian



	//printf("Results for %s:\n", probname[problem]);
	printf("Levenberg-Marquardt returned %d in %g iter, reason %g\nSolution: ", ret, info[5], info[6]);
	for(int i=0; i<m; ++i)
		printf("%.7g ", parameter_vector[i]);
	printf("\n\nMinimization info:\n");
	for(int i=0; i<LM_INFO_SZ; ++i)
		printf("%g ", info[i]);
	printf("\n");

	out << "Levenberg-Marquardt returned " << ret << " in " << info[5] << " iter, reason " << info[6] << endl;
	out << " Solution ";
	for(int i=0; i<m; ++i){
		out <<	parameter_vector[i] << " ";
	}
	out << endl << endl;

	out << "minimization information " << endl;
	for(int i=0; i<LM_INFO_SZ; ++i){
		out << info[i] << " ";
	}
	out << endl << endl;

	//R = Rx*Ry*Rz;
	// X params first, then Y params.
	Matrix Rx(3, 3);
	Matrix Ry(3, 3);
	Matrix Rz(3, 3);

	Rx.Row(1) << 1 <<  0 << 0;
	Rx.Row(2) << 0 << cos(parameter_vector[0]) << -sin(parameter_vector[0]);
	Rx.Row(3) << 0 << sin(parameter_vector[0]) << cos(parameter_vector[0]);

	Ry.Row(1) << cos(parameter_vector[1]) << 0 << sin(parameter_vector[1]);
	Ry.Row(2) << 0 << 1 << 0;
	Ry.Row(3) << -sin(parameter_vector[1]) << 0 << cos(parameter_vector[1]);

	Rz.Row(1) << cos(parameter_vector[2]) << -sin(parameter_vector[2]) << 0;
	Rz.Row(2) << sin(parameter_vector[2]) << cos(parameter_vector[2]) << 0;
	Rz.Row(3) << 0 << 0 << 1;


	X.SubMatrix(1, 3, 1, 3) = Rx*Ry*Rz;
	X(1, 4) = parameter_vector[3];
	X(2, 4) = parameter_vector[4];
	X(3, 4) = parameter_vector[5];

	Rx.Row(1) << 1 <<  0 << 0;
	Rx.Row(2) << 0 << cos(parameter_vector[6]) << -sin(parameter_vector[6]);
	Rx.Row(3) << 0 << sin(parameter_vector[6]) << cos(parameter_vector[6]);

	Ry.Row(1) << cos(parameter_vector[7]) << 0 << sin(parameter_vector[7]);
	Ry.Row(2) << 0 << 1 << 0;
	Ry.Row(3) << -sin(parameter_vector[7]) << 0 << cos(parameter_vector[7]);

	Rz.Row(1) << cos(parameter_vector[8]) << -sin(parameter_vector[8]) << 0;
	Rz.Row(2) << sin(parameter_vector[8]) << cos(parameter_vector[8]) << 0;
	Rz.Row(3) << 0 << 0 << 1;


	Z.SubMatrix(1, 3, 1, 3) = Rx*Ry*Rz;
	Z(1, 4) = parameter_vector[9];
	Z(2, 4) = parameter_vector[10];
	Z(3, 4) = parameter_vector[11];
}

void residuals_euler2(double *p, double *x, int m, int n, void *data){

	//	char ch;
	CaliData *dptr;

	dptr=(CaliData*)data;


	int index = 0;
	// get the current parameters ...

	double thetax_X = p[0];
	double thetay_X = p[1];
	double thetaz_X = p[2];
	double t0X = p[3];
	double t1X = p[4];
	double t2X = p[5];

	double thetax_Z = p[6];
	double thetay_Z = p[7];
	double thetaz_Z = p[8];
	double t0Z = p[9];
	double t1Z = p[10];
	double t2Z = p[11];

	double a0, a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11;
	double b0, b1, b2, b3, b4, b5, b6, b7, b8, b9, b10, b11;

	for (int i = 0; i < int(dptr->As->size()); i++){
		a0 = dptr->As->at(i)(1, 1);
		a1 = dptr->As->at(i)(1, 2);
		a2 = dptr->As->at(i)(1, 3);
		a3 = dptr->As->at(i)(1, 4);

		a4 = dptr->As->at(i)(2, 1);
		a5 = dptr->As->at(i)(2, 2);
		a6 = dptr->As->at(i)(2, 3);
		a7 = dptr->As->at(i)(2, 4);

		a8 = dptr->As->at(i)(3, 1);
		a9 = dptr->As->at(i)(3, 2);
		a10 = dptr->As->at(i)(3, 3);
		a11 = dptr->As->at(i)(3, 4);

		b0 = dptr->Bs->at(i)(1, 1);
		b1 = dptr->Bs->at(i)(1, 2);
		b2 = dptr->Bs->at(i)(1, 3);
		b3 = dptr->Bs->at(i)(1, 4);

		b4 = dptr->Bs->at(i)(2, 1);
		b5 = dptr->Bs->at(i)(2, 2);
		b6 = dptr->Bs->at(i)(2, 3);
		b7 = dptr->Bs->at(i)(2, 4);

		b8 = dptr->Bs->at(i)(3, 1);
		b9 = dptr->Bs->at(i)(3, 2);
		b10 = dptr->Bs->at(i)(3, 3);
		b11 = dptr->Bs->at(i)(3, 4);

		x[index] = cos(thetay_Z)*(b6*(sin(thetax_X)*sin(thetaz_X)
				-cos(thetax_X)*sin(thetay_X)*cos(thetaz_X))
				+b5*(cos(thetax_X)*sin(thetaz_X)
						+sin(thetax_X)*sin(thetay_X)*cos(thetaz_X))
						+b4*cos(thetay_X)*cos(thetaz_X))*sin(thetaz_Z)
						-cos(thetay_Z)*(b2*(sin(thetax_X)*sin(thetaz_X)
								-cos(thetax_X)*sin(thetay_X)*cos(thetaz_X))
								+b1*(cos(thetax_X)*sin(thetaz_X)
										+sin(thetax_X)*sin(thetay_X)*cos(thetaz_X))
										+b0*cos(thetay_X)*cos(thetaz_X))*cos(thetaz_Z)
										-sin(thetay_Z)*(b10*(sin(thetax_X)*sin(thetaz_X)
												-cos(thetax_X)*sin(thetay_X)*cos(thetaz_X))
												+b9*(cos(thetax_X)*sin(thetaz_X)
														+sin(thetax_X)*sin(thetay_X)*cos(thetaz_X))
														+b8*cos(thetay_X)*cos(thetaz_X))+a0;

		x[index + 1] = cos(thetay_Z)*(b5*(cos(thetax_X)*cos(thetaz_X)
				-sin(thetax_X)*sin(thetay_X)*sin(thetaz_X))
				+b6*(cos(thetax_X)*sin(thetay_X)*sin(thetaz_X)
						+sin(thetax_X)*cos(thetaz_X))
						-b4*cos(thetay_X)*sin(thetaz_X))*sin(thetaz_Z)
						-cos(thetay_Z)*(b1*(cos(thetax_X)*cos(thetaz_X)
								-sin(thetax_X)*sin(thetay_X)*sin(thetaz_X))
								+b2*(cos(thetax_X)*sin(thetay_X)*sin(thetaz_X)
										+sin(thetax_X)*cos(thetaz_X))
										-b0*cos(thetay_X)*sin(thetaz_X))*cos(thetaz_Z)
										-sin(thetay_Z)*(b9*(cos(thetax_X)*cos(thetaz_X)
												-sin(thetax_X)*sin(thetay_X)*sin(thetaz_X))
												+b10*(cos(thetax_X)*sin(thetay_X)*sin(thetaz_X)
														+sin(thetax_X)*cos(thetaz_X))
														-b8*cos(thetay_X)*sin(thetaz_X))+a1;

		x[index + 2 ] = (b4*sin(thetay_X)-b5*sin(thetax_X)*cos(thetay_X)
				+b6*cos(thetax_X)*cos(thetay_X))
				*cos(thetay_Z)*sin(thetaz_Z)
				-(b0*sin(thetay_X)-b1*sin(thetax_X)*cos(thetay_X)
						+b2*cos(thetax_X)*cos(thetay_X))
						*cos(thetay_Z)*cos(thetaz_Z)
						-(b8*sin(thetay_X)-b9*sin(thetax_X)*cos(thetay_X)
								+b10*cos(thetax_X)*cos(thetay_X))
								*sin(thetay_Z)+a2;

		x[index + 3] = (b6*t2X+b5*t1X+b4*t0X+b7)*cos(thetay_Z)*sin(thetaz_Z)
												 -(b2*t2X+b1*t1X+b0*t0X+b3)*cos(thetay_Z)*cos(thetaz_Z)
												 -(b10*t2X+b9*t1X+b8*t0X+b11)*sin(thetay_Z)-t0Z+a3;

		// matrix element 2 1 [1 is first element]
		x[index + 4] = -(b6*(sin(thetax_X)*sin(thetaz_X)-cos(thetax_X)*sin(thetay_X)*cos(thetaz_X))
				+b5*(cos(thetax_X)*sin(thetaz_X)+sin(thetax_X)*sin(thetay_X)*cos(thetaz_X))
				+b4*cos(thetay_X)*cos(thetaz_X))
				*(cos(thetax_Z)*cos(thetaz_Z)-sin(thetax_Z)*sin(thetay_Z)*sin(thetaz_Z))
				-(b2*(sin(thetax_X)*sin(thetaz_X)-cos(thetax_X)*sin(thetay_X)*cos(thetaz_X))
						+b1*(cos(thetax_X)*sin(thetaz_X)+sin(thetax_X)*sin(thetay_X)*cos(thetaz_X))
						+b0*cos(thetay_X)*cos(thetaz_X))
						*(cos(thetax_Z)*sin(thetaz_Z)+sin(thetax_Z)*sin(thetay_Z)*cos(thetaz_Z))
						+sin(thetax_Z)*cos(thetay_Z)
						*(b10*(sin(thetax_X)*sin(thetaz_X)
								-cos(thetax_X)*sin(thetay_X)*cos(thetaz_X))
								+b9*(cos(thetax_X)*sin(thetaz_X)
										+sin(thetax_X)*sin(thetay_X)*cos(thetaz_X))
										+b8*cos(thetay_X)*cos(thetaz_X))+a4;


		x[index + 5] = -(b5*(cos(thetax_X)*cos(thetaz_X)-sin(thetax_X)*sin(thetay_X)*sin(thetaz_X))
				+b6*(cos(thetax_X)*sin(thetay_X)*sin(thetaz_X)+sin(thetax_X)*cos(thetaz_X))
				-b4*cos(thetay_X)*sin(thetaz_X))
				*(cos(thetax_Z)*cos(thetaz_Z)-sin(thetax_Z)*sin(thetay_Z)*sin(thetaz_Z))
				-(b1*(cos(thetax_X)*cos(thetaz_X)-sin(thetax_X)*sin(thetay_X)*sin(thetaz_X))
						+b2*(cos(thetax_X)*sin(thetay_X)*sin(thetaz_X)+sin(thetax_X)*cos(thetaz_X))
						-b0*cos(thetay_X)*sin(thetaz_X))
						*(cos(thetax_Z)*sin(thetaz_Z)+sin(thetax_Z)*sin(thetay_Z)*cos(thetaz_Z))
						+sin(thetax_Z)*cos(thetay_Z)
						*(b9*(cos(thetax_X)*cos(thetaz_X)
								-sin(thetax_X)*sin(thetay_X)*sin(thetaz_X))
								+b10*(cos(thetax_X)*sin(thetay_X)*sin(thetaz_X)
										+sin(thetax_X)*cos(thetaz_X))
										-b8*cos(thetay_X)*sin(thetaz_X))+a5;

		x[index + 6] = -(b4*sin(thetay_X)-b5*sin(thetax_X)*cos(thetay_X)
				+b6*cos(thetax_X)*cos(thetay_X))
				*(cos(thetax_Z)*cos(thetaz_Z)-sin(thetax_Z)*sin(thetay_Z)*sin(thetaz_Z))
				-(b0*sin(thetay_X)-b1*sin(thetax_X)*cos(thetay_X)
						+b2*cos(thetax_X)*cos(thetay_X))
						*(cos(thetax_Z)*sin(thetaz_Z)+sin(thetax_Z)*sin(thetay_Z)*cos(thetaz_Z))
						+sin(thetax_Z)*(b8*sin(thetay_X)-b9*sin(thetax_X)*cos(thetay_X)
								+b10*cos(thetax_X)*cos(thetay_X))
								*cos(thetay_Z)+a6;

		x[index + 7] = -(b6*t2X+b5*t1X+b4*t0X+b7)*(cos(thetax_Z)*cos(thetaz_Z)
				-sin(thetax_Z)*sin(thetay_Z)*sin(thetaz_Z))
				-(b2*t2X+b1*t1X+b0*t0X+b3)*(cos(thetax_Z)*sin(thetaz_Z)
						+sin(thetax_Z)*sin(thetay_Z)*cos(thetaz_Z))
						+(b10*t2X+b9*t1X+b8*t0X+b11)*sin(thetax_Z)*cos(thetay_Z)-t1Z+a7;

		// third row starting
		x[index + 8] = -(b6*(sin(thetax_X)*sin(thetaz_X)-cos(thetax_X)*sin(thetay_X)*cos(thetaz_X))
				+b5*(cos(thetax_X)*sin(thetaz_X)+sin(thetax_X)*sin(thetay_X)*cos(thetaz_X))
				+b4*cos(thetay_X)*cos(thetaz_X))
				*(cos(thetax_Z)*sin(thetay_Z)*sin(thetaz_Z)+sin(thetax_Z)*cos(thetaz_Z))
				-(b2*(sin(thetax_X)*sin(thetaz_X)-cos(thetax_X)*sin(thetay_X)*cos(thetaz_X))
						+b1*(cos(thetax_X)*sin(thetaz_X)+sin(thetax_X)*sin(thetay_X)*cos(thetaz_X))
						+b0*cos(thetay_X)*cos(thetaz_X))
						*(sin(thetax_Z)*sin(thetaz_Z)-cos(thetax_Z)*sin(thetay_Z)*cos(thetaz_Z))
						-cos(thetax_Z)*cos(thetay_Z)
						*(b10*(sin(thetax_X)*sin(thetaz_X)
								-cos(thetax_X)*sin(thetay_X)*cos(thetaz_X))
								+b9*(cos(thetax_X)*sin(thetaz_X)
										+sin(thetax_X)*sin(thetay_X)*cos(thetaz_X))
										+b8*cos(thetay_X)*cos(thetaz_X))+a8;

		x[index + 9] = -(b5*(cos(thetax_X)*cos(thetaz_X)-sin(thetax_X)*sin(thetay_X)*sin(thetaz_X))
				+b6*(cos(thetax_X)*sin(thetay_X)*sin(thetaz_X)+sin(thetax_X)*cos(thetaz_X))
				-b4*cos(thetay_X)*sin(thetaz_X))
				*(cos(thetax_Z)*sin(thetay_Z)*sin(thetaz_Z)+sin(thetax_Z)*cos(thetaz_Z))
				-(b1*(cos(thetax_X)*cos(thetaz_X)-sin(thetax_X)*sin(thetay_X)*sin(thetaz_X))
						+b2*(cos(thetax_X)*sin(thetay_X)*sin(thetaz_X)+sin(thetax_X)*cos(thetaz_X))
						-b0*cos(thetay_X)*sin(thetaz_X))
						*(sin(thetax_Z)*sin(thetaz_Z)-cos(thetax_Z)*sin(thetay_Z)*cos(thetaz_Z))
						-cos(thetax_Z)*cos(thetay_Z)
						*(b9*(cos(thetax_X)*cos(thetaz_X)
								-sin(thetax_X)*sin(thetay_X)*sin(thetaz_X))
								+b10*(cos(thetax_X)*sin(thetay_X)*sin(thetaz_X)
										+sin(thetax_X)*cos(thetaz_X))
										-b8*cos(thetay_X)*sin(thetaz_X))+a9;

		x[index + 10] = -(b4*sin(thetay_X)-b5*sin(thetax_X)*cos(thetay_X)
				+b6*cos(thetax_X)*cos(thetay_X))
				*(cos(thetax_Z)*sin(thetay_Z)*sin(thetaz_Z)+sin(thetax_Z)*cos(thetaz_Z))
				-(b0*sin(thetay_X)-b1*sin(thetax_X)*cos(thetay_X)
						+b2*cos(thetax_X)*cos(thetay_X))
						*(sin(thetax_Z)*sin(thetaz_Z)-cos(thetax_Z)*sin(thetay_Z)*cos(thetaz_Z))
						-cos(thetax_Z)*(b8*sin(thetay_X)-b9*sin(thetax_X)*cos(thetay_X)
								+b10*cos(thetax_X)*cos(thetay_X))
								*cos(thetay_Z)+a10;

		x[index + 11] = -(b6*t2X+b5*t1X+b4*t0X+b7)*(cos(thetax_Z)*sin(thetay_Z)*sin(thetaz_Z)
				+sin(thetax_Z)*cos(thetaz_Z))
				-(b2*t2X+b1*t1X+b0*t0X+b3)*(sin(thetax_Z)*sin(thetaz_Z)
						-cos(thetax_Z)*sin(thetay_Z)*cos(thetaz_Z))
						-(b10*t2X+b9*t1X+b8*t0X+b11)*cos(thetax_Z)*cos(thetay_Z)-t2Z+a11;

		index += 12;
	}

}


void jacobian_euler2(double *p, double *jac, int m, int n, void *data){
	CaliData *dptr;

	dptr=(CaliData*)data;


	int index = 0;

	// get the current parameters ...

	double thetax_X = p[0];
	double thetay_X = p[1];
	double thetaz_X = p[2];
	double t0X = p[3];
	double t1X = p[4];
	double t2X = p[5];

	double thetax_Z = p[6];
	double thetay_Z = p[7];
	double thetaz_Z = p[8];
	double t0Z = p[9];
	double t1Z = p[10];
	double t2Z = p[11];

	double a0, a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11;
	double b0, b1, b2, b3, b4, b5, b6, b7, b8, b9, b10, b11;

	for (int i = 0; i < int(dptr->As->size()); i++){
		a0 = dptr->As->at(i)(1, 1);
		a1 = dptr->As->at(i)(1, 2);
		a2 = dptr->As->at(i)(1, 3);
		a3 = dptr->As->at(i)(1, 4);

		a4 = dptr->As->at(i)(2, 1);
		a5 = dptr->As->at(i)(2, 2);
		a6 = dptr->As->at(i)(2, 3);
		a7 = dptr->As->at(i)(2, 4);

		a8 = dptr->As->at(i)(3, 1);
		a9 = dptr->As->at(i)(3, 2);
		a10 = dptr->As->at(i)(3, 3);
		a11 = dptr->As->at(i)(3, 4);

		b0 = dptr->Bs->at(i)(1, 1);
		b1 = dptr->Bs->at(i)(1, 2);
		b2 = dptr->Bs->at(i)(1, 3);
		b3 = dptr->Bs->at(i)(1, 4);

		b4 = dptr->Bs->at(i)(2, 1);
		b5 = dptr->Bs->at(i)(2, 2);
		b6 = dptr->Bs->at(i)(2, 3);
		b7 = dptr->Bs->at(i)(2, 4);

		b8 = dptr->Bs->at(i)(3, 1);
		b9 = dptr->Bs->at(i)(3, 2);
		b10 = dptr->Bs->at(i)(3, 3);
		b11 = dptr->Bs->at(i)(3, 4);

		// d r0
		jac[index] = cos(thetay_Z)*(b5*(cos(thetax_X)*sin(thetay_X)*cos(thetaz_X)
				-sin(thetax_X)*sin(thetaz_X))
				+b6*(cos(thetax_X)*sin(thetaz_X)
						+sin(thetax_X)*sin(thetay_X)*cos(thetaz_X)))*sin(thetaz_Z)
						-cos(thetay_Z)*(b1*(cos(thetax_X)*sin(thetay_X)*cos(thetaz_X)
								-sin(thetax_X)*sin(thetaz_X))
								+b2*(cos(thetax_X)*sin(thetaz_X)
										+sin(thetax_X)*sin(thetay_X)*cos(thetaz_X)))*cos(thetaz_Z)
										-sin(thetay_Z)*(b9*(cos(thetax_X)*sin(thetay_X)*cos(thetaz_X)
												-sin(thetax_X)*sin(thetaz_X))
												+b10*(cos(thetax_X)*sin(thetaz_X)
														+sin(thetax_X)*sin(thetay_X)*cos(thetaz_X)));


		jac[index + 1] = cos(thetay_Z)*(-b4*sin(thetay_X)*cos(thetaz_X)
				+b5*sin(thetax_X)*cos(thetay_X)*cos(thetaz_X)
				-b6*cos(thetax_X)*cos(thetay_X)*cos(thetaz_X))*sin(thetaz_Z)
				-cos(thetay_Z)*(-b0*sin(thetay_X)*cos(thetaz_X)
						+b1*sin(thetax_X)*cos(thetay_X)*cos(thetaz_X)
						-b2*cos(thetax_X)*cos(thetay_X)*cos(thetaz_X))*cos(thetaz_Z)
						-sin(thetay_Z)*(-b8*sin(thetay_X)*cos(thetaz_X)
								+b9*sin(thetax_X)*cos(thetay_X)*cos(thetaz_X)
								-b10*cos(thetax_X)*cos(thetay_X)*cos(thetaz_X));


		jac[index + 2] = cos(thetay_Z)*(b5*(cos(thetax_X)*cos(thetaz_X)
				-sin(thetax_X)*sin(thetay_X)*sin(thetaz_X))
				+b6*(cos(thetax_X)*sin(thetay_X)*sin(thetaz_X)
						+sin(thetax_X)*cos(thetaz_X))
						-b4*cos(thetay_X)*sin(thetaz_X))*sin(thetaz_Z)
						-cos(thetay_Z)*(b1*(cos(thetax_X)*cos(thetaz_X)
								-sin(thetax_X)*sin(thetay_X)*sin(thetaz_X))
								+b2*(cos(thetax_X)*sin(thetay_X)*sin(thetaz_X)
										+sin(thetax_X)*cos(thetaz_X))
										-b0*cos(thetay_X)*sin(thetaz_X))*cos(thetaz_Z)
										-sin(thetay_Z)*(b9*(cos(thetax_X)*cos(thetaz_X)
												-sin(thetax_X)*sin(thetay_X)*sin(thetaz_X))
												+b10*(cos(thetax_X)*sin(thetay_X)*sin(thetaz_X)
														+sin(thetax_X)*cos(thetaz_X))
														-b8*cos(thetay_X)*sin(thetaz_X));

		jac[index + 3] = 0;
		jac[index + 4] = 0;
		jac[index + 5] = 0;

		jac[index + 6] = 0;
		jac[index + 7] = -sin(thetay_Z)*(b6*(sin(thetax_X)*sin(thetaz_X)
				-cos(thetax_X)*sin(thetay_X)*cos(thetaz_X))
				+b5*(cos(thetax_X)*sin(thetaz_X)
						+sin(thetax_X)*sin(thetay_X)*cos(thetaz_X))
						+b4*cos(thetay_X)*cos(thetaz_X))*sin(thetaz_Z)
						+sin(thetay_Z)*(b2*(sin(thetax_X)*sin(thetaz_X)
								-cos(thetax_X)*sin(thetay_X)*cos(thetaz_X))
								+b1*(cos(thetax_X)*sin(thetaz_X)
										+sin(thetax_X)*sin(thetay_X)*cos(thetaz_X))
										+b0*cos(thetay_X)*cos(thetaz_X))*cos(thetaz_Z)
										-cos(thetay_Z)*(b10*(sin(thetax_X)*sin(thetaz_X)
												-cos(thetax_X)*sin(thetay_X)*cos(thetaz_X))
												+b9*(cos(thetax_X)*sin(thetaz_X)
														+sin(thetax_X)*sin(thetay_X)*cos(thetaz_X))
														+b8*cos(thetay_X)*cos(thetaz_X));

		jac[index + 8] = cos(thetay_Z)*(b2*(sin(thetax_X)*sin(thetaz_X)
				-cos(thetax_X)*sin(thetay_X)*cos(thetaz_X))
				+b1*(cos(thetax_X)*sin(thetaz_X)
						+sin(thetax_X)*sin(thetay_X)*cos(thetaz_X))
						+b0*cos(thetay_X)*cos(thetaz_X))*sin(thetaz_Z)
						+cos(thetay_Z)*(b6*(sin(thetax_X)*sin(thetaz_X)
								-cos(thetax_X)*sin(thetay_X)*cos(thetaz_X))
								+b5*(cos(thetax_X)*sin(thetaz_X)
										+sin(thetax_X)*sin(thetay_X)*cos(thetaz_X))
										+b4*cos(thetay_X)*cos(thetaz_X))*cos(thetaz_Z);

		jac[index + 9] = 0;
		jac[index + 10] =0;
		jac[index + 11] =0;

		index += 12;

		// d r1
		jac[index] = 	cos(thetay_Z)*(b6*(cos(thetax_X)*cos(thetaz_X)
				-sin(thetax_X)*sin(thetay_X)*sin(thetaz_X))
				+b5*(-cos(thetax_X)*sin(thetay_X)*sin(thetaz_X)
						-sin(thetax_X)*cos(thetaz_X)))*sin(thetaz_Z)
						-cos(thetay_Z)*(b2*(cos(thetax_X)*cos(thetaz_X)
								-sin(thetax_X)*sin(thetay_X)*sin(thetaz_X))
								+b1*(-cos(thetax_X)*sin(thetay_X)*sin(thetaz_X)
										-sin(thetax_X)*cos(thetaz_X)))*cos(thetaz_Z)
										-sin(thetay_Z)*(b10*(cos(thetax_X)*cos(thetaz_X)
												-sin(thetax_X)*sin(thetay_X)*sin(thetaz_X))
												+b9*(-cos(thetax_X)*sin(thetay_X)*sin(thetaz_X)
														-sin(thetax_X)*cos(thetaz_X)));

		jac[index + 1] = cos(thetay_Z)*(b4*sin(thetay_X)*sin(thetaz_X)
				-b5*sin(thetax_X)*cos(thetay_X)*sin(thetaz_X)
				+b6*cos(thetax_X)*cos(thetay_X)*sin(thetaz_X))*sin(thetaz_Z)
				-cos(thetay_Z)*(b0*sin(thetay_X)*sin(thetaz_X)
						-b1*sin(thetax_X)*cos(thetay_X)*sin(thetaz_X)
						+b2*cos(thetax_X)*cos(thetay_X)*sin(thetaz_X))*cos(thetaz_Z)
						-sin(thetay_Z)*(b8*sin(thetay_X)*sin(thetaz_X)
								-b9*sin(thetax_X)*cos(thetay_X)*sin(thetaz_X)
								+b10*cos(thetax_X)*cos(thetay_X)*sin(thetaz_X));

		jac[index + 2] = cos(thetay_Z)*(b6*(cos(thetax_X)*sin(thetay_X)*cos(thetaz_X)
				-sin(thetax_X)*sin(thetaz_X))
				+b5*(-cos(thetax_X)*sin(thetaz_X)
						-sin(thetax_X)*sin(thetay_X)*cos(thetaz_X))
						-b4*cos(thetay_X)*cos(thetaz_X))*sin(thetaz_Z)
						-cos(thetay_Z)*(b2*(cos(thetax_X)*sin(thetay_X)*cos(thetaz_X)
								-sin(thetax_X)*sin(thetaz_X))
								+b1*(-cos(thetax_X)*sin(thetaz_X)
										-sin(thetax_X)*sin(thetay_X)*cos(thetaz_X))
										-b0*cos(thetay_X)*cos(thetaz_X))*cos(thetaz_Z)
										-sin(thetay_Z)*(b10*(cos(thetax_X)*sin(thetay_X)*cos(thetaz_X)
												-sin(thetax_X)*sin(thetaz_X))
												+b9*(-cos(thetax_X)*sin(thetaz_X)
														-sin(thetax_X)*sin(thetay_X)*cos(thetaz_X))
														-b8*cos(thetay_X)*cos(thetaz_X));


		jac[index + 3] = 0;
		jac[index + 4] = 0;
		jac[index + 5] = 0;

		jac[index + 6] = 0;
		jac[index + 7] =-sin(thetay_Z)*(b5*(cos(thetax_X)*cos(thetaz_X)
				-sin(thetax_X)*sin(thetay_X)*sin(thetaz_X))
				+b6*(cos(thetax_X)*sin(thetay_X)*sin(thetaz_X)
						+sin(thetax_X)*cos(thetaz_X))
						-b4*cos(thetay_X)*sin(thetaz_X))*sin(thetaz_Z)
						+sin(thetay_Z)*(b1*(cos(thetax_X)*cos(thetaz_X)
								-sin(thetax_X)*sin(thetay_X)*sin(thetaz_X))
								+b2*(cos(thetax_X)*sin(thetay_X)*sin(thetaz_X)
										+sin(thetax_X)*cos(thetaz_X))
										-b0*cos(thetay_X)*sin(thetaz_X))*cos(thetaz_Z)
										-cos(thetay_Z)*(b9*(cos(thetax_X)*cos(thetaz_X)
												-sin(thetax_X)*sin(thetay_X)*sin(thetaz_X))
												+b10*(cos(thetax_X)*sin(thetay_X)*sin(thetaz_X)
														+sin(thetax_X)*cos(thetaz_X))
														-b8*cos(thetay_X)*sin(thetaz_X));

		jac[index + 8] = cos(thetay_Z)*(b1*(cos(thetax_X)*cos(thetaz_X)
				-sin(thetax_X)*sin(thetay_X)*sin(thetaz_X))
				+b2*(cos(thetax_X)*sin(thetay_X)*sin(thetaz_X)
						+sin(thetax_X)*cos(thetaz_X))
						-b0*cos(thetay_X)*sin(thetaz_X))*sin(thetaz_Z)
						+cos(thetay_Z)*(b5*(cos(thetax_X)*cos(thetaz_X)
								-sin(thetax_X)*sin(thetay_X)*sin(thetaz_X))
								+b6*(cos(thetax_X)*sin(thetay_X)*sin(thetaz_X)
										+sin(thetax_X)*cos(thetaz_X))
										-b4*cos(thetay_X)*sin(thetaz_X))*cos(thetaz_Z);

		jac[index + 9] = 0;
		jac[index + 10] =0;
		jac[index + 11] =0;

		index += 12;


		////////d r2
		jac[index] = (-b6*sin(thetax_X)*cos(thetay_X)-b5*cos(thetax_X)*cos(thetay_X))
								*cos(thetay_Z)*sin(thetaz_Z)
								-(-b2*sin(thetax_X)*cos(thetay_X)-b1*cos(thetax_X)*cos(thetay_X))
								*cos(thetay_Z)*cos(thetaz_Z)
								-(-b10*sin(thetax_X)*cos(thetay_X)-b9*cos(thetax_X)*cos(thetay_X))
								*sin(thetay_Z);
		jac[index + 1] = (b5*sin(thetax_X)*sin(thetay_X)-b6*cos(thetax_X)*sin(thetay_X)
				+b4*cos(thetay_X))
				*cos(thetay_Z)*sin(thetaz_Z)
				-(b1*sin(thetax_X)*sin(thetay_X)-b2*cos(thetax_X)*sin(thetay_X)
						+b0*cos(thetay_X))
						*cos(thetay_Z)*cos(thetaz_Z)
						-(b9*sin(thetax_X)*sin(thetay_X)-b10*cos(thetax_X)*sin(thetay_X)
								+b8*cos(thetay_X))
								*sin(thetay_Z);
		jac[index + 2]= 0;


		jac[index + 3] = 0;
		jac[index + 4] = 0;
		jac[index + 5] = 0;

		jac[index + 6] = 0;
		jac[index + 7] = -(b4*sin(thetay_X)-b5*sin(thetax_X)*cos(thetay_X)
				+b6*cos(thetax_X)*cos(thetay_X))
				*sin(thetay_Z)*sin(thetaz_Z)
				+(b0*sin(thetay_X)-b1*sin(thetax_X)*cos(thetay_X)
						+b2*cos(thetax_X)*cos(thetay_X))
						*sin(thetay_Z)*cos(thetaz_Z)
						-(b8*sin(thetay_X)-b9*sin(thetax_X)*cos(thetay_X)
								+b10*cos(thetax_X)*cos(thetay_X))
								*cos(thetay_Z);

		jac[index + 8] = (b0*sin(thetay_X)-b1*sin(thetax_X)*cos(thetay_X)
				+b2*cos(thetax_X)*cos(thetay_X))
				*cos(thetay_Z)*sin(thetaz_Z)
				+(b4*sin(thetay_X)-b5*sin(thetax_X)*cos(thetay_X)
						+b6*cos(thetax_X)*cos(thetay_X))
						*cos(thetay_Z)*cos(thetaz_Z);

		jac[index + 9] = 0;
		jac[index + 10] =0;
		jac[index + 11] =0;

		index += 12;

		///// d r3

		jac[index] = 0;
		jac[index + 1] = 0;
		jac[index + 2] = 0;

		jac[index + 3] = b4*cos(thetay_Z)*sin(thetaz_Z)-b0*cos(thetay_Z)*cos(thetaz_Z)-b8*sin(thetay_Z);
		jac[index + 4] = b5*cos(thetay_Z)*sin(thetaz_Z)-b1*cos(thetay_Z)*cos(thetaz_Z)-b9*sin(thetay_Z);
		jac[index + 5] = b6*cos(thetay_Z)*sin(thetaz_Z)-b2*cos(thetay_Z)*cos(thetaz_Z)
                                    								  -b10*sin(thetay_Z);

		jac[index + 6] = 0;
		jac[index + 7] = -(b6*t2X+b5*t1X+b4*t0X+b7)*sin(thetay_Z)*sin(thetaz_Z)
										 +(b2*t2X+b1*t1X+b0*t0X+b3)*sin(thetay_Z)*cos(thetaz_Z)
										 -(b10*t2X+b9*t1X+b8*t0X+b11)*cos(thetay_Z);

		jac[index + 8] = (b2*t2X+b1*t1X+b0*t0X+b3)*cos(thetay_Z)*sin(thetaz_Z)
										 +(b6*t2X+b5*t1X+b4*t0X+b7)*cos(thetay_Z)*cos(thetaz_Z);

		jac[index + 9] = -1;
		jac[index + 10] = 0;
		jac[index + 11] = 0;

		index += 12;

		////// d r4 ME[2][1]
		jac[index] = -(b5*(cos(thetax_X)*sin(thetay_X)*cos(thetaz_X)-sin(thetax_X)*sin(thetaz_X))
				+b6*(cos(thetax_X)*sin(thetaz_X)+sin(thetax_X)*sin(thetay_X)*cos(thetaz_X)))
				*(cos(thetax_Z)*cos(thetaz_Z)-sin(thetax_Z)*sin(thetay_Z)*sin(thetaz_Z))
				-(b1*(cos(thetax_X)*sin(thetay_X)*cos(thetaz_X)-sin(thetax_X)*sin(thetaz_X))
						+b2*(cos(thetax_X)*sin(thetaz_X)+sin(thetax_X)*sin(thetay_X)*cos(thetaz_X)))
						*(cos(thetax_Z)*sin(thetaz_Z)+sin(thetax_Z)*sin(thetay_Z)*cos(thetaz_Z))
						+sin(thetax_Z)*cos(thetay_Z)
						*(b9*(cos(thetax_X)*sin(thetay_X)*cos(thetaz_X)
								-sin(thetax_X)*sin(thetaz_X))
								+b10*(cos(thetax_X)*sin(thetaz_X)
										+sin(thetax_X)*sin(thetay_X)*cos(thetaz_X)));

		jac[index + 1] = -(-b4*sin(thetay_X)*cos(thetaz_X)+b5*sin(thetax_X)*cos(thetay_X)*cos(thetaz_X)
				-b6*cos(thetax_X)*cos(thetay_X)
				*cos(thetaz_X))
				*(cos(thetax_Z)*cos(thetaz_Z)-sin(thetax_Z)*sin(thetay_Z)*sin(thetaz_Z))
				-(-b0*sin(thetay_X)*cos(thetaz_X)+b1*sin(thetax_X)*cos(thetay_X)
						*cos(thetaz_X)
						-b2*cos(thetax_X)*cos(thetay_X)
						*cos(thetaz_X))
						*(cos(thetax_Z)*sin(thetaz_Z)+sin(thetax_Z)*sin(thetay_Z)*cos(thetaz_Z))
						+sin(thetax_Z)*cos(thetay_Z)
						*(-b8*sin(thetay_X)*cos(thetaz_X)
								+b9*sin(thetax_X)*cos(thetay_X)*cos(thetaz_X)
								-b10*cos(thetax_X)*cos(thetay_X)*cos(thetaz_X));

		jac[index + 2] =-(b5*(cos(thetax_X)*cos(thetaz_X)-sin(thetax_X)*sin(thetay_X)*sin(thetaz_X))
				+b6*(cos(thetax_X)*sin(thetay_X)*sin(thetaz_X)+sin(thetax_X)*cos(thetaz_X))
				-b4*cos(thetay_X)*sin(thetaz_X))
				*(cos(thetax_Z)*cos(thetaz_Z)-sin(thetax_Z)*sin(thetay_Z)*sin(thetaz_Z))
				-(b1*(cos(thetax_X)*cos(thetaz_X)-sin(thetax_X)*sin(thetay_X)*sin(thetaz_X))
						+b2*(cos(thetax_X)*sin(thetay_X)*sin(thetaz_X)+sin(thetax_X)*cos(thetaz_X))
						-b0*cos(thetay_X)*sin(thetaz_X))
						*(cos(thetax_Z)*sin(thetaz_Z)+sin(thetax_Z)*sin(thetay_Z)*cos(thetaz_Z))
						+sin(thetax_Z)*cos(thetay_Z)
						*(b9*(cos(thetax_X)*cos(thetaz_X)
								-sin(thetax_X)*sin(thetay_X)*sin(thetaz_X))
								+b10*(cos(thetax_X)*sin(thetay_X)*sin(thetaz_X)
										+sin(thetax_X)*cos(thetaz_X))
										-b8*cos(thetay_X)*sin(thetaz_X));




		jac[index + 3] = 0;
		jac[index + 4] = 0;
		jac[index + 5] = 0;

		jac[index + 6] = -(b6*(sin(thetax_X)*sin(thetaz_X)-cos(thetax_X)*sin(thetay_X)*cos(thetaz_X))
				+b5*(cos(thetax_X)*sin(thetaz_X)+sin(thetax_X)*sin(thetay_X)*cos(thetaz_X))
				+b4*cos(thetay_X)*cos(thetaz_X))
				*(-cos(thetax_Z)*sin(thetay_Z)*sin(thetaz_Z)-sin(thetax_Z)*cos(thetaz_Z))
				-(b2*(sin(thetax_X)*sin(thetaz_X)-cos(thetax_X)*sin(thetay_X)*cos(thetaz_X))
						+b1*(cos(thetax_X)*sin(thetaz_X)+sin(thetax_X)*sin(thetay_X)*cos(thetaz_X))
						+b0*cos(thetay_X)*cos(thetaz_X))
						*(cos(thetax_Z)*sin(thetay_Z)*cos(thetaz_Z)-sin(thetax_Z)*sin(thetaz_Z))
						+cos(thetax_Z)*cos(thetay_Z)
						*(b10*(sin(thetax_X)*sin(thetaz_X)
								-cos(thetax_X)*sin(thetay_X)*cos(thetaz_X))
								+b9*(cos(thetax_X)*sin(thetaz_X)
										+sin(thetax_X)*sin(thetay_X)*cos(thetaz_X))
										+b8*cos(thetay_X)*cos(thetaz_X));



		jac[index + 7] = sin(thetax_Z)*cos(thetay_Z)
                    								 *(b6*(sin(thetax_X)*sin(thetaz_X)
                    										 -cos(thetax_X)*sin(thetay_X)*cos(thetaz_X))
                    										 +b5*(cos(thetax_X)*sin(thetaz_X)
                    												 +sin(thetax_X)*sin(thetay_X)*cos(thetaz_X))
                    												 +b4*cos(thetay_X)*cos(thetaz_X))*sin(thetaz_Z)
                    												 -sin(thetax_Z)*cos(thetay_Z)
                    												 *(b2*(sin(thetax_X)*sin(thetaz_X)
                    														 -cos(thetax_X)*sin(thetay_X)*cos(thetaz_X))
                    														 +b1*(cos(thetax_X)*sin(thetaz_X)
                    																 +sin(thetax_X)*sin(thetay_X)*cos(thetaz_X))
                    																 +b0*cos(thetay_X)*cos(thetaz_X))*cos(thetaz_Z)
                    																 -sin(thetax_Z)*sin(thetay_Z)
                    																 *(b10*(sin(thetax_X)*sin(thetaz_X)
                    																		 -cos(thetax_X)*sin(thetay_X)*cos(thetaz_X))
                    																		 +b9*(cos(thetax_X)*sin(thetaz_X)
                    																				 +sin(thetax_X)*sin(thetay_X)*cos(thetaz_X))
                    																				 +b8*cos(thetay_X)*cos(thetaz_X));



		jac[index + 8] = -(b2*(sin(thetax_X)*sin(thetaz_X)-cos(thetax_X)*sin(thetay_X)*cos(thetaz_X))
				+b1*(cos(thetax_X)*sin(thetaz_X)+sin(thetax_X)*sin(thetay_X)*cos(thetaz_X))
				+b0*cos(thetay_X)*cos(thetaz_X))
				*(cos(thetax_Z)*cos(thetaz_Z)-sin(thetax_Z)*sin(thetay_Z)*sin(thetaz_Z))
				-(b6*(sin(thetax_X)*sin(thetaz_X)-cos(thetax_X)*sin(thetay_X)*cos(thetaz_X))
						+b5*(cos(thetax_X)*sin(thetaz_X)+sin(thetax_X)*sin(thetay_X)*cos(thetaz_X))
						+b4*cos(thetay_X)*cos(thetaz_X))
						*(-cos(thetax_Z)*sin(thetaz_Z)-sin(thetax_Z)*sin(thetay_Z)*cos(thetaz_Z));

		jac[index + 9] = 0;
		jac[index + 10] = 0;
		jac[index + 11] = 0;

		index += 12;

		/////// d r5 ME[2][2]

		jac[index] =-(b6*(cos(thetax_X)*cos(thetaz_X)-sin(thetax_X)*sin(thetay_X)*sin(thetaz_X))
				+b5*(-cos(thetax_X)*sin(thetay_X)*sin(thetaz_X)-sin(thetax_X)*cos(thetaz_X)))
				*(cos(thetax_Z)*cos(thetaz_Z)-sin(thetax_Z)*sin(thetay_Z)*sin(thetaz_Z))
				-(b2*(cos(thetax_X)*cos(thetaz_X)-sin(thetax_X)*sin(thetay_X)*sin(thetaz_X))
						+b1*(-cos(thetax_X)*sin(thetay_X)*sin(thetaz_X)
								-sin(thetax_X)*cos(thetaz_X)))
								*(cos(thetax_Z)*sin(thetaz_Z)+sin(thetax_Z)*sin(thetay_Z)*cos(thetaz_Z))
								+sin(thetax_Z)*cos(thetay_Z)
								*(b10*(cos(thetax_X)*cos(thetaz_X)
										-sin(thetax_X)*sin(thetay_X)*sin(thetaz_X))
										+b9*(-cos(thetax_X)*sin(thetay_X)*sin(thetaz_X)
												-sin(thetax_X)*cos(thetaz_X)));

		jac[index + 1] = -(b4*sin(thetay_X)*sin(thetaz_X)-b5*sin(thetax_X)*cos(thetay_X)*sin(thetaz_X)
				+b6*cos(thetax_X)*cos(thetay_X)*sin(thetaz_X))
				*(cos(thetax_Z)*cos(thetaz_Z)-sin(thetax_Z)*sin(thetay_Z)*sin(thetaz_Z))
				-(b0*sin(thetay_X)*sin(thetaz_X)-b1*sin(thetax_X)*cos(thetay_X)*sin(thetaz_X)
						+b2*cos(thetax_X)*cos(thetay_X)
						*sin(thetaz_X))
						*(cos(thetax_Z)*sin(thetaz_Z)+sin(thetax_Z)*sin(thetay_Z)*cos(thetaz_Z))
						+sin(thetax_Z)*cos(thetay_Z)
						*(b8*sin(thetay_X)*sin(thetaz_X)
								-b9*sin(thetax_X)*cos(thetay_X)*sin(thetaz_X)
								+b10*cos(thetax_X)*cos(thetay_X)*sin(thetaz_X));

		jac[index + 2] =-(b6*(cos(thetax_X)*sin(thetay_X)*cos(thetaz_X)-sin(thetax_X)*sin(thetaz_X))
				+b5*(-cos(thetax_X)*sin(thetaz_X)-sin(thetax_X)*sin(thetay_X)*cos(thetaz_X))
				-b4*cos(thetay_X)*cos(thetaz_X))
				*(cos(thetax_Z)*cos(thetaz_Z)-sin(thetax_Z)*sin(thetay_Z)*sin(thetaz_Z))
				-(b2*(cos(thetax_X)*sin(thetay_X)*cos(thetaz_X)-sin(thetax_X)*sin(thetaz_X))
						+b1*(-cos(thetax_X)*sin(thetaz_X)-sin(thetax_X)*sin(thetay_X)*cos(thetaz_X))
						-b0*cos(thetay_X)*cos(thetaz_X))
						*(cos(thetax_Z)*sin(thetaz_Z)+sin(thetax_Z)*sin(thetay_Z)*cos(thetaz_Z))
						+sin(thetax_Z)*cos(thetay_Z)
						*(b10*(cos(thetax_X)*sin(thetay_X)*cos(thetaz_X)
								-sin(thetax_X)*sin(thetaz_X))
								+b9*(-cos(thetax_X)*sin(thetaz_X)
										-sin(thetax_X)*sin(thetay_X)*cos(thetaz_X))
										-b8*cos(thetay_X)*cos(thetaz_X));
		jac[index + 3] = 0;
		jac[index + 4] = 0;
		jac[index + 5] = 0;

		jac[index + 6] =-(b5*(cos(thetax_X)*cos(thetaz_X)-sin(thetax_X)*sin(thetay_X)*sin(thetaz_X))
				+b6*(cos(thetax_X)*sin(thetay_X)*sin(thetaz_X)+sin(thetax_X)*cos(thetaz_X))
				-b4*cos(thetay_X)*sin(thetaz_X))
				*(-cos(thetax_Z)*sin(thetay_Z)*sin(thetaz_Z)-sin(thetax_Z)*cos(thetaz_Z))
				-(b1*(cos(thetax_X)*cos(thetaz_X)-sin(thetax_X)*sin(thetay_X)*sin(thetaz_X))
						+b2*(cos(thetax_X)*sin(thetay_X)*sin(thetaz_X)+sin(thetax_X)*cos(thetaz_X))
						-b0*cos(thetay_X)*sin(thetaz_X))
						*(cos(thetax_Z)*sin(thetay_Z)*cos(thetaz_Z)-sin(thetax_Z)*sin(thetaz_Z))
						+cos(thetax_Z)*cos(thetay_Z)
						*(b9*(cos(thetax_X)*cos(thetaz_X)
								-sin(thetax_X)*sin(thetay_X)*sin(thetaz_X))
								+b10*(cos(thetax_X)*sin(thetay_X)*sin(thetaz_X)
										+sin(thetax_X)*cos(thetaz_X))
										-b8*cos(thetay_X)*sin(thetaz_X));

		jac[index + 7] =sin(thetax_Z)*cos(thetay_Z)
                    								 *(b5*(cos(thetax_X)*cos(thetaz_X)
                    										 -sin(thetax_X)*sin(thetay_X)*sin(thetaz_X))
                    										 +b6*(cos(thetax_X)*sin(thetay_X)*sin(thetaz_X)
                    												 +sin(thetax_X)*cos(thetaz_X))
                    												 -b4*cos(thetay_X)*sin(thetaz_X))*sin(thetaz_Z)
                    												 -sin(thetax_Z)*cos(thetay_Z)
                    												 *(b1*(cos(thetax_X)*cos(thetaz_X)
                    														 -sin(thetax_X)*sin(thetay_X)*sin(thetaz_X))
                    														 +b2*(cos(thetax_X)*sin(thetay_X)*sin(thetaz_X)
                    																 +sin(thetax_X)*cos(thetaz_X))
                    																 -b0*cos(thetay_X)*sin(thetaz_X))*cos(thetaz_Z)
                    																 -sin(thetax_Z)*sin(thetay_Z)
                    																 *(b9*(cos(thetax_X)*cos(thetaz_X)
                    																		 -sin(thetax_X)*sin(thetay_X)*sin(thetaz_X))
                    																		 +b10*(cos(thetax_X)*sin(thetay_X)*sin(thetaz_X)
                    																				 +sin(thetax_X)*cos(thetaz_X))
                    																				 -b8*cos(thetay_X)*sin(thetaz_X));
		jac[index + 8] = -(b1*(cos(thetax_X)*cos(thetaz_X)-sin(thetax_X)*sin(thetay_X)*sin(thetaz_X))
				+b2*(cos(thetax_X)*sin(thetay_X)*sin(thetaz_X)+sin(thetax_X)*cos(thetaz_X))
				-b0*cos(thetay_X)*sin(thetaz_X))
				*(cos(thetax_Z)*cos(thetaz_Z)-sin(thetax_Z)*sin(thetay_Z)*sin(thetaz_Z))
				-(b5*(cos(thetax_X)*cos(thetaz_X)-sin(thetax_X)*sin(thetay_X)*sin(thetaz_X))
						+b6*(cos(thetax_X)*sin(thetay_X)*sin(thetaz_X)+sin(thetax_X)*cos(thetaz_X))
						-b4*cos(thetay_X)*sin(thetaz_X))
						*(-cos(thetax_Z)*sin(thetaz_Z)-sin(thetax_Z)*sin(thetay_Z)*cos(thetaz_Z));
		jac[index + 9] = 0;
		jac[index + 10] = 0;
		jac[index + 11] = 0;

		index += 12;

		/////////// d r6 ME[2][3]
		jac[index + 0] = -(-b6*sin(thetax_X)*cos(thetay_X)-b5*cos(thetax_X)*cos(thetay_X))
		                    				   *(cos(thetax_Z)*cos(thetaz_Z)-sin(thetax_Z)*sin(thetay_Z)*sin(thetaz_Z))
		                    				   -(-b2*sin(thetax_X)*cos(thetay_X)-b1*cos(thetax_X)*cos(thetay_X))
		                    				   *(cos(thetax_Z)*sin(thetaz_Z)+sin(thetax_Z)*sin(thetay_Z)*cos(thetaz_Z))
		                    				   +sin(thetax_Z)*(-b10*sin(thetax_X)*cos(thetay_X)
		                    						   -b9*cos(thetax_X)*cos(thetay_X))*cos(thetay_Z);
		jac[index + 1] = -(b5*sin(thetax_X)*sin(thetay_X)-b6*cos(thetax_X)*sin(thetay_X)
				+b4*cos(thetay_X))
				*(cos(thetax_Z)*cos(thetaz_Z)-sin(thetax_Z)*sin(thetay_Z)*sin(thetaz_Z))
				-(b1*sin(thetax_X)*sin(thetay_X)-b2*cos(thetax_X)*sin(thetay_X)
						+b0*cos(thetay_X))
						*(cos(thetax_Z)*sin(thetaz_Z)+sin(thetax_Z)*sin(thetay_Z)*cos(thetaz_Z))
						+sin(thetax_Z)*(b9*sin(thetax_X)*sin(thetay_X)
								-b10*cos(thetax_X)*sin(thetay_X)+b8*cos(thetay_X))
								*cos(thetay_Z);
		jac[index + 2] = 0;

		jac[index + 3] = 0;
		jac[index + 4] = 0;
		jac[index + 5] = 0;

		jac[index + 6] =
				-(b4*sin(thetay_X)-b5*sin(thetax_X)*cos(thetay_X)
						+b6*cos(thetax_X)*cos(thetay_X))
						*(-cos(thetax_Z)*sin(thetay_Z)*sin(thetaz_Z)-sin(thetax_Z)*cos(thetaz_Z))
						-(b0*sin(thetay_X)-b1*sin(thetax_X)*cos(thetay_X)
								+b2*cos(thetax_X)*cos(thetay_X))
								*(cos(thetax_Z)*sin(thetay_Z)*cos(thetaz_Z)-sin(thetax_Z)*sin(thetaz_Z))
								+cos(thetax_Z)*(b8*sin(thetay_X)-b9*sin(thetax_X)*cos(thetay_X)
										+b10*cos(thetax_X)*cos(thetay_X))
										*cos(thetay_Z);

		jac[index + 7] =
				sin(thetax_Z)*(b4*sin(thetay_X)-b5*sin(thetax_X)*cos(thetay_X)
						+b6*cos(thetax_X)*cos(thetay_X))*cos(thetay_Z)
						*sin(thetaz_Z)
						-sin(thetax_Z)*(b0*sin(thetay_X)-b1*sin(thetax_X)*cos(thetay_X)
								+b2*cos(thetax_X)*cos(thetay_X))
								*cos(thetay_Z)*cos(thetaz_Z)
								-sin(thetax_Z)*(b8*sin(thetay_X)-b9*sin(thetax_X)*cos(thetay_X)
										+b10*cos(thetax_X)*cos(thetay_X))
										*sin(thetay_Z);

		jac[index + 8] =
				-(b0*sin(thetay_X)-b1*sin(thetax_X)*cos(thetay_X)
						+b2*cos(thetax_X)*cos(thetay_X))
						*(cos(thetax_Z)*cos(thetaz_Z)-sin(thetax_Z)*sin(thetay_Z)*sin(thetaz_Z))
						-(b4*sin(thetay_X)-b5*sin(thetax_X)*cos(thetay_X)
								+b6*cos(thetax_X)*cos(thetay_X))
								*(-cos(thetax_Z)*sin(thetaz_Z)-sin(thetax_Z)*sin(thetay_Z)*cos(thetaz_Z));

		jac[index + 9] = 0;
		jac[index + 10] = 0;
		jac[index + 11] = 0;

		index += 12;


		/// d r7 ME[2][4]
		jac[index + 0] = 0;
		jac[index + 1] = 0;
		jac[index + 2] = 0;

		jac[index + 3] = -b4*(cos(thetax_Z)*cos(thetaz_Z)-sin(thetax_Z)*sin(thetay_Z)*sin(thetaz_Z))
												 -b0*(cos(thetax_Z)*sin(thetaz_Z)+sin(thetax_Z)*sin(thetay_Z)*cos(thetaz_Z))
												 +b8*sin(thetax_Z)*cos(thetay_Z);

		jac[index + 4] = -b5*(cos(thetax_Z)*cos(thetaz_Z)-sin(thetax_Z)*sin(thetay_Z)*sin(thetaz_Z))
												 -b1*(cos(thetax_Z)*sin(thetaz_Z)+sin(thetax_Z)*sin(thetay_Z)*cos(thetaz_Z))
												 +b9*sin(thetax_Z)*cos(thetay_Z);

		jac[index + 5] = -b6*(cos(thetax_Z)*cos(thetaz_Z)-sin(thetax_Z)*sin(thetay_Z)*sin(thetaz_Z))
												 -b2*(cos(thetax_Z)*sin(thetaz_Z)+sin(thetax_Z)*sin(thetay_Z)*cos(thetaz_Z))
												 +b10*sin(thetax_Z)*cos(thetay_Z);

		jac[index + 6] =-(b6*t2X+b5*t1X+b4*t0X+b7)*(-cos(thetax_Z)*sin(thetay_Z)*sin(thetaz_Z)
				-sin(thetax_Z)*cos(thetaz_Z))
				-(b2*t2X+b1*t1X+b0*t0X+b3)*(cos(thetax_Z)*sin(thetay_Z)*cos(thetaz_Z)
						-sin(thetax_Z)*sin(thetaz_Z))
						+(b10*t2X+b9*t1X+b8*t0X+b11)*cos(thetax_Z)*cos(thetay_Z);

		jac[index + 7] =(b6*t2X+b5*t1X+b4*t0X+b7)*sin(thetax_Z)*cos(thetay_Z)*sin(thetaz_Z)
												 -(b2*t2X+b1*t1X+b0*t0X+b3)*sin(thetax_Z)*cos(thetay_Z)*cos(thetaz_Z)
												 -(b10*t2X+b9*t1X+b8*t0X+b11)*sin(thetax_Z)*sin(thetay_Z);

		jac[index + 8] =-(b2*t2X+b1*t1X+b0*t0X+b3)*(cos(thetax_Z)*cos(thetaz_Z)
				-sin(thetax_Z)*sin(thetay_Z)*sin(thetaz_Z))
				-(b6*t2X+b5*t1X+b4*t0X+b7)*(-cos(thetax_Z)*sin(thetaz_Z)
						-sin(thetax_Z)*sin(thetay_Z)*cos(thetaz_Z));


		jac[index + 9] = 0;
		jac[index + 10] = -1;
		jac[index + 11] = 0;

		index += 12;

		// d r8 //////////ME[3][1] ////////////////////////////////////////////
		jac[index + 0] =  -(b5*(cos(thetax_X)*sin(thetay_X)*cos(thetaz_X)-sin(thetax_X)*sin(thetaz_X))
				+b6*(cos(thetax_X)*sin(thetaz_X)+sin(thetax_X)*sin(thetay_X)*cos(thetaz_X)))
				*(cos(thetax_Z)*sin(thetay_Z)*sin(thetaz_Z)+sin(thetax_Z)*cos(thetaz_Z))
				-(b1*(cos(thetax_X)*sin(thetay_X)*cos(thetaz_X)-sin(thetax_X)*sin(thetaz_X))
						+b2*(cos(thetax_X)*sin(thetaz_X)+sin(thetax_X)*sin(thetay_X)*cos(thetaz_X)))
						*(sin(thetax_Z)*sin(thetaz_Z)-cos(thetax_Z)*sin(thetay_Z)*cos(thetaz_Z))
						-cos(thetax_Z)*cos(thetay_Z)
						*(b9*(cos(thetax_X)*sin(thetay_X)*cos(thetaz_X)
								-sin(thetax_X)*sin(thetaz_X))
								+b10*(cos(thetax_X)*sin(thetaz_X)
										+sin(thetax_X)*sin(thetay_X)*cos(thetaz_X)));

		jac[index + 1] =  -(-b4*sin(thetay_X)*cos(thetaz_X)+b5*sin(thetax_X)*cos(thetay_X)*cos(thetaz_X)
				-b6*cos(thetax_X)*cos(thetay_X)
				*cos(thetaz_X))
				*(cos(thetax_Z)*sin(thetay_Z)*sin(thetaz_Z)+sin(thetax_Z)*cos(thetaz_Z))
				-(-b0*sin(thetay_X)*cos(thetaz_X)+b1*sin(thetax_X)*cos(thetay_X)
						*cos(thetaz_X)
						-b2*cos(thetax_X)*cos(thetay_X)
						*cos(thetaz_X))
						*(sin(thetax_Z)*sin(thetaz_Z)-cos(thetax_Z)*sin(thetay_Z)*cos(thetaz_Z))
						-cos(thetax_Z)*cos(thetay_Z)
						*(-b8*sin(thetay_X)*cos(thetaz_X)
								+b9*sin(thetax_X)*cos(thetay_X)*cos(thetaz_X)
								-b10*cos(thetax_X)*cos(thetay_X)*cos(thetaz_X));

		jac[index + 2] =  -(b5*(cos(thetax_X)*cos(thetaz_X)-sin(thetax_X)*sin(thetay_X)*sin(thetaz_X))
				+b6*(cos(thetax_X)*sin(thetay_X)*sin(thetaz_X)+sin(thetax_X)*cos(thetaz_X))
				-b4*cos(thetay_X)*sin(thetaz_X))
				*(cos(thetax_Z)*sin(thetay_Z)*sin(thetaz_Z)+sin(thetax_Z)*cos(thetaz_Z))
				-(b1*(cos(thetax_X)*cos(thetaz_X)-sin(thetax_X)*sin(thetay_X)*sin(thetaz_X))
						+b2*(cos(thetax_X)*sin(thetay_X)*sin(thetaz_X)+sin(thetax_X)*cos(thetaz_X))
						-b0*cos(thetay_X)*sin(thetaz_X))
						*(sin(thetax_Z)*sin(thetaz_Z)-cos(thetax_Z)*sin(thetay_Z)*cos(thetaz_Z))
						-cos(thetax_Z)*cos(thetay_Z)
						*(b9*(cos(thetax_X)*cos(thetaz_X)
								-sin(thetax_X)*sin(thetay_X)*sin(thetaz_X))
								+b10*(cos(thetax_X)*sin(thetay_X)*sin(thetaz_X)
										+sin(thetax_X)*cos(thetaz_X))
										-b8*cos(thetay_X)*sin(thetaz_X));



		jac[index + 3] =  0   ;
		jac[index + 4] =   0  ;
		jac[index + 5] =    0 ;

		jac[index + 6] = -(b6*(sin(thetax_X)*sin(thetaz_X)-cos(thetax_X)*sin(thetay_X)*cos(thetaz_X))
				+b5*(cos(thetax_X)*sin(thetaz_X)+sin(thetax_X)*sin(thetay_X)*cos(thetaz_X))
				+b4*cos(thetay_X)*cos(thetaz_X))
				*(cos(thetax_Z)*cos(thetaz_Z)-sin(thetax_Z)*sin(thetay_Z)*sin(thetaz_Z))
				-(b2*(sin(thetax_X)*sin(thetaz_X)-cos(thetax_X)*sin(thetay_X)*cos(thetaz_X))
						+b1*(cos(thetax_X)*sin(thetaz_X)+sin(thetax_X)*sin(thetay_X)*cos(thetaz_X))
						+b0*cos(thetay_X)*cos(thetaz_X))
						*(cos(thetax_Z)*sin(thetaz_Z)+sin(thetax_Z)*sin(thetay_Z)*cos(thetaz_Z))
						+sin(thetax_Z)*cos(thetay_Z)
						*(b10*(sin(thetax_X)*sin(thetaz_X)
								-cos(thetax_X)*sin(thetay_X)*cos(thetaz_X))
								+b9*(cos(thetax_X)*sin(thetaz_X)
										+sin(thetax_X)*sin(thetay_X)*cos(thetaz_X))
										+b8*cos(thetay_X)*cos(thetaz_X));

		jac[index + 7] =  -cos(thetax_Z)*cos(thetay_Z)
                    										  *(b6*(sin(thetax_X)*sin(thetaz_X)
                    												  -cos(thetax_X)*sin(thetay_X)*cos(thetaz_X))
                    												  +b5*(cos(thetax_X)*sin(thetaz_X)
                    														  +sin(thetax_X)*sin(thetay_X)*cos(thetaz_X))
                    														  +b4*cos(thetay_X)*cos(thetaz_X))*sin(thetaz_Z)
                    														  +cos(thetax_Z)*cos(thetay_Z)
                    														  *(b2*(sin(thetax_X)*sin(thetaz_X)
                    																  -cos(thetax_X)*sin(thetay_X)*cos(thetaz_X))
                    																  +b1*(cos(thetax_X)*sin(thetaz_X)
                    																		  +sin(thetax_X)*sin(thetay_X)*cos(thetaz_X))
                    																		  +b0*cos(thetay_X)*cos(thetaz_X))*cos(thetaz_Z)
                    																		  +cos(thetax_Z)*sin(thetay_Z)
                    																		  *(b10*(sin(thetax_X)*sin(thetaz_X)
                    																				  -cos(thetax_X)*sin(thetay_X)*cos(thetaz_X))
                    																				  +b9*(cos(thetax_X)*sin(thetaz_X)
                    																						  +sin(thetax_X)*sin(thetay_X)*cos(thetaz_X))
                    																						  +b8*cos(thetay_X)*cos(thetaz_X));

		jac[index + 8] = -(b2*(sin(thetax_X)*sin(thetaz_X)-cos(thetax_X)*sin(thetay_X)*cos(thetaz_X))
				+b1*(cos(thetax_X)*sin(thetaz_X)+sin(thetax_X)*sin(thetay_X)*cos(thetaz_X))
				+b0*cos(thetay_X)*cos(thetaz_X))
				*(cos(thetax_Z)*sin(thetay_Z)*sin(thetaz_Z)+sin(thetax_Z)*cos(thetaz_Z))
				-(b6*(sin(thetax_X)*sin(thetaz_X)-cos(thetax_X)*sin(thetay_X)*cos(thetaz_X))
						+b5*(cos(thetax_X)*sin(thetaz_X)+sin(thetax_X)*sin(thetay_X)*cos(thetaz_X))
						+b4*cos(thetay_X)*cos(thetaz_X))
						*(cos(thetax_Z)*sin(thetay_Z)*cos(thetaz_Z)-sin(thetax_Z)*sin(thetaz_Z));

		jac[index + 9] =  0   ;
		jac[index + 10] =  0   ;
		jac[index + 11] =   0  ;

		index += 12;

		/////// d r9  ME[3][2]

		jac[index + 0] =  -(b6*(cos(thetax_X)*cos(thetaz_X)-sin(thetax_X)*sin(thetay_X)*sin(thetaz_X))
				+b5*(-cos(thetax_X)*sin(thetay_X)*sin(thetaz_X)-sin(thetax_X)*cos(thetaz_X)))
				*(cos(thetax_Z)*sin(thetay_Z)*sin(thetaz_Z)+sin(thetax_Z)*cos(thetaz_Z))
				-(b2*(cos(thetax_X)*cos(thetaz_X)-sin(thetax_X)*sin(thetay_X)*sin(thetaz_X))
						+b1*(-cos(thetax_X)*sin(thetay_X)*sin(thetaz_X)
								-sin(thetax_X)*cos(thetaz_X)))
								*(sin(thetax_Z)*sin(thetaz_Z)-cos(thetax_Z)*sin(thetay_Z)*cos(thetaz_Z))
								-cos(thetax_Z)*cos(thetay_Z)
								*(b10*(cos(thetax_X)*cos(thetaz_X)
										-sin(thetax_X)*sin(thetay_X)*sin(thetaz_X))
										+b9*(-cos(thetax_X)*sin(thetay_X)*sin(thetaz_X)
												-sin(thetax_X)*cos(thetaz_X)));


		jac[index + 1] =  -(b4*sin(thetay_X)*sin(thetaz_X)-b5*sin(thetax_X)*cos(thetay_X)*sin(thetaz_X)
				+b6*cos(thetax_X)*cos(thetay_X)*sin(thetaz_X))
				*(cos(thetax_Z)*sin(thetay_Z)*sin(thetaz_Z)+sin(thetax_Z)*cos(thetaz_Z))
				-(b0*sin(thetay_X)*sin(thetaz_X)-b1*sin(thetax_X)*cos(thetay_X)*sin(thetaz_X)
						+b2*cos(thetax_X)*cos(thetay_X)
						*sin(thetaz_X))
						*(sin(thetax_Z)*sin(thetaz_Z)-cos(thetax_Z)*sin(thetay_Z)*cos(thetaz_Z))
						-cos(thetax_Z)*cos(thetay_Z)
						*(b8*sin(thetay_X)*sin(thetaz_X)
								-b9*sin(thetax_X)*cos(thetay_X)*sin(thetaz_X)
								+b10*cos(thetax_X)*cos(thetay_X)*sin(thetaz_X));

		jac[index + 2] = -(b6*(cos(thetax_X)*sin(thetay_X)*cos(thetaz_X)-sin(thetax_X)*sin(thetaz_X))
				+b5*(-cos(thetax_X)*sin(thetaz_X)-sin(thetax_X)*sin(thetay_X)*cos(thetaz_X))
				-b4*cos(thetay_X)*cos(thetaz_X))
				*(cos(thetax_Z)*sin(thetay_Z)*sin(thetaz_Z)+sin(thetax_Z)*cos(thetaz_Z))
				-(b2*(cos(thetax_X)*sin(thetay_X)*cos(thetaz_X)-sin(thetax_X)*sin(thetaz_X))
						+b1*(-cos(thetax_X)*sin(thetaz_X)-sin(thetax_X)*sin(thetay_X)*cos(thetaz_X))
						-b0*cos(thetay_X)*cos(thetaz_X))
						*(sin(thetax_Z)*sin(thetaz_Z)-cos(thetax_Z)*sin(thetay_Z)*cos(thetaz_Z))
						-cos(thetax_Z)*cos(thetay_Z)
						*(b10*(cos(thetax_X)*sin(thetay_X)*cos(thetaz_X)
								-sin(thetax_X)*sin(thetaz_X))
								+b9*(-cos(thetax_X)*sin(thetaz_X)
										-sin(thetax_X)*sin(thetay_X)*cos(thetaz_X))
										-b8*cos(thetay_X)*cos(thetaz_X));


		jac[index + 3] = 0    ;
		jac[index + 4] =  0   ;
		jac[index + 5] =   0  ;

		jac[index + 6] = -(b5*(cos(thetax_X)*cos(thetaz_X)-sin(thetax_X)*sin(thetay_X)*sin(thetaz_X))
				+b6*(cos(thetax_X)*sin(thetay_X)*sin(thetaz_X)+sin(thetax_X)*cos(thetaz_X))
				-b4*cos(thetay_X)*sin(thetaz_X))
				*(cos(thetax_Z)*cos(thetaz_Z)-sin(thetax_Z)*sin(thetay_Z)*sin(thetaz_Z))
				-(b1*(cos(thetax_X)*cos(thetaz_X)-sin(thetax_X)*sin(thetay_X)*sin(thetaz_X))
						+b2*(cos(thetax_X)*sin(thetay_X)*sin(thetaz_X)+sin(thetax_X)*cos(thetaz_X))
						-b0*cos(thetay_X)*sin(thetaz_X))
						*(cos(thetax_Z)*sin(thetaz_Z)+sin(thetax_Z)*sin(thetay_Z)*cos(thetaz_Z))
						+sin(thetax_Z)*cos(thetay_Z)
						*(b9*(cos(thetax_X)*cos(thetaz_X)
								-sin(thetax_X)*sin(thetay_X)*sin(thetaz_X))
								+b10*(cos(thetax_X)*sin(thetay_X)*sin(thetaz_X)
										+sin(thetax_X)*cos(thetaz_X))
										-b8*cos(thetay_X)*sin(thetaz_X));

		jac[index + 7] =  -cos(thetax_Z)*cos(thetay_Z)
                    								  *(b5*(cos(thetax_X)*cos(thetaz_X)
                    										  -sin(thetax_X)*sin(thetay_X)*sin(thetaz_X))
                    										  +b6*(cos(thetax_X)*sin(thetay_X)*sin(thetaz_X)
                    												  +sin(thetax_X)*cos(thetaz_X))
                    												  -b4*cos(thetay_X)*sin(thetaz_X))*sin(thetaz_Z)
                    												  +cos(thetax_Z)*cos(thetay_Z)
                    												  *(b1*(cos(thetax_X)*cos(thetaz_X)
                    														  -sin(thetax_X)*sin(thetay_X)*sin(thetaz_X))
                    														  +b2*(cos(thetax_X)*sin(thetay_X)*sin(thetaz_X)
                    																  +sin(thetax_X)*cos(thetaz_X))
                    																  -b0*cos(thetay_X)*sin(thetaz_X))*cos(thetaz_Z)
                    																  +cos(thetax_Z)*sin(thetay_Z)
                    																  *(b9*(cos(thetax_X)*cos(thetaz_X)
                    																		  -sin(thetax_X)*sin(thetay_X)*sin(thetaz_X))
                    																		  +b10*(cos(thetax_X)*sin(thetay_X)*sin(thetaz_X)
                    																				  +sin(thetax_X)*cos(thetaz_X))
                    																				  -b8*cos(thetay_X)*sin(thetaz_X));



		jac[index + 8] = -(b1*(cos(thetax_X)*cos(thetaz_X)-sin(thetax_X)*sin(thetay_X)*sin(thetaz_X))
				+b2*(cos(thetax_X)*sin(thetay_X)*sin(thetaz_X)+sin(thetax_X)*cos(thetaz_X))
				-b0*cos(thetay_X)*sin(thetaz_X))
				*(cos(thetax_Z)*sin(thetay_Z)*sin(thetaz_Z)+sin(thetax_Z)*cos(thetaz_Z))
				-(b5*(cos(thetax_X)*cos(thetaz_X)-sin(thetax_X)*sin(thetay_X)*sin(thetaz_X))
						+b6*(cos(thetax_X)*sin(thetay_X)*sin(thetaz_X)+sin(thetax_X)*cos(thetaz_X))
						-b4*cos(thetay_X)*sin(thetaz_X))
						*(cos(thetax_Z)*sin(thetay_Z)*cos(thetaz_Z)-sin(thetax_Z)*sin(thetaz_Z));

		jac[index + 9] =  0   ;
		jac[index + 10] =  0   ;
		jac[index + 11] =   0  ;

		index += 12;

		/// d r10  ME[3][3]

		jac[index + 0] =  -(-b6*sin(thetax_X)*cos(thetay_X)-b5*cos(thetax_X)*cos(thetay_X))
		                				 *(cos(thetax_Z)*sin(thetay_Z)*sin(thetaz_Z)+sin(thetax_Z)*cos(thetaz_Z))
		                				 -(-b2*sin(thetax_X)*cos(thetay_X)-b1*cos(thetax_X)*cos(thetay_X))
		                				 *(sin(thetax_Z)*sin(thetaz_Z)-cos(thetax_Z)*sin(thetay_Z)*cos(thetaz_Z))
		                				 -cos(thetax_Z)*(-b10*sin(thetax_X)*cos(thetay_X)
		                						 -b9*cos(thetax_X)*cos(thetay_X))*cos(thetay_Z);

		jac[index + 1] =  -(b5*sin(thetax_X)*sin(thetay_X)-b6*cos(thetax_X)*sin(thetay_X)
				+b4*cos(thetay_X))
				*(cos(thetax_Z)*sin(thetay_Z)*sin(thetaz_Z)+sin(thetax_Z)*cos(thetaz_Z))
				-(b1*sin(thetax_X)*sin(thetay_X)-b2*cos(thetax_X)*sin(thetay_X)
						+b0*cos(thetay_X))
						*(sin(thetax_Z)*sin(thetaz_Z)-cos(thetax_Z)*sin(thetay_Z)*cos(thetaz_Z))
						-cos(thetax_Z)*(b9*sin(thetax_X)*sin(thetay_X)
								-b10*cos(thetax_X)*sin(thetay_X)+b8*cos(thetay_X))
								*cos(thetay_Z);


		jac[index + 2] = 0   ;

		jac[index + 3] =  0   ;
		jac[index + 4] =   0  ;
		jac[index + 5] =    0 ;

		jac[index + 6] =  -(b4*sin(thetay_X)-b5*sin(thetax_X)*cos(thetay_X)
				+b6*cos(thetax_X)*cos(thetay_X))
				*(cos(thetax_Z)*cos(thetaz_Z)-sin(thetax_Z)*sin(thetay_Z)*sin(thetaz_Z))
				-(b0*sin(thetay_X)-b1*sin(thetax_X)*cos(thetay_X)
						+b2*cos(thetax_X)*cos(thetay_X))
						*(cos(thetax_Z)*sin(thetaz_Z)+sin(thetax_Z)*sin(thetay_Z)*cos(thetaz_Z))
						+sin(thetax_Z)*(b8*sin(thetay_X)-b9*sin(thetax_X)*cos(thetay_X)
								+b10*cos(thetax_X)*cos(thetay_X))
								*cos(thetay_Z);


		jac[index + 7] = -cos(thetax_Z)*(b4*sin(thetay_X)-b5*sin(thetax_X)*cos(thetay_X)
				+b6*cos(thetax_X)*cos(thetay_X))*cos(thetay_Z)
				*sin(thetaz_Z)
				+cos(thetax_Z)*(b0*sin(thetay_X)-b1*sin(thetax_X)*cos(thetay_X)
						+b2*cos(thetax_X)*cos(thetay_X))
						*cos(thetay_Z)*cos(thetaz_Z)
						+cos(thetax_Z)*(b8*sin(thetay_X)-b9*sin(thetax_X)*cos(thetay_X)
								+b10*cos(thetax_X)*cos(thetay_X))
								*sin(thetay_Z);

		jac[index + 8] =  -(b0*sin(thetay_X)-b1*sin(thetax_X)*cos(thetay_X)
				+b2*cos(thetax_X)*cos(thetay_X))
				*(cos(thetax_Z)*sin(thetay_Z)*sin(thetaz_Z)+sin(thetax_Z)*cos(thetaz_Z))
				-(b4*sin(thetay_X)-b5*sin(thetax_X)*cos(thetay_X)
						+b6*cos(thetax_X)*cos(thetay_X))
						*(cos(thetax_Z)*sin(thetay_Z)*cos(thetaz_Z)-sin(thetax_Z)*sin(thetaz_Z));


		jac[index + 9] =  0   ;
		jac[index + 10] =  0   ;
		jac[index + 11] =   0  ;

		index += 12;

		/// d r11  ME[3][4]


		jac[index + 0] =  0  ;
		jac[index + 1] =  0  ;
		jac[index + 2] =  0  ;

		jac[index + 3] = -b4*(cos(thetax_Z)*sin(thetay_Z)*sin(thetaz_Z)+sin(thetax_Z)*cos(thetaz_Z))
												 -b0*(sin(thetax_Z)*sin(thetaz_Z)-cos(thetax_Z)*sin(thetay_Z)*cos(thetaz_Z))
												 -b8*cos(thetax_Z)*cos(thetay_Z) ;

		jac[index + 4] =  -b5*(cos(thetax_Z)*sin(thetay_Z)*sin(thetaz_Z)+sin(thetax_Z)*cos(thetaz_Z))
												 -b1*(sin(thetax_Z)*sin(thetaz_Z)-cos(thetax_Z)*sin(thetay_Z)*cos(thetaz_Z))
												 -b9*cos(thetax_Z)*cos(thetay_Z)  ;
		jac[index + 5] =  -b6*(cos(thetax_Z)*sin(thetay_Z)*sin(thetaz_Z)+sin(thetax_Z)*cos(thetaz_Z))
												 -b2*(sin(thetax_Z)*sin(thetaz_Z)-cos(thetax_Z)*sin(thetay_Z)*cos(thetaz_Z))
												 -b10*cos(thetax_Z)*cos(thetay_Z)   ;

		jac[index + 6] =   -(b6*t2X+b5*t1X+b4*t0X+b7)*(cos(thetax_Z)*cos(thetaz_Z)
				-sin(thetax_Z)*sin(thetay_Z)*sin(thetaz_Z))
				-(b2*t2X+b1*t1X+b0*t0X+b3)*(cos(thetax_Z)*sin(thetaz_Z)
						+sin(thetax_Z)*sin(thetay_Z)*cos(thetaz_Z))
						+(b10*t2X+b9*t1X+b8*t0X+b11)*sin(thetax_Z)*cos(thetay_Z);

		jac[index + 7] = -(b6*t2X+b5*t1X+b4*t0X+b7)*cos(thetax_Z)*cos(thetay_Z)*sin(thetaz_Z)
												 +(b2*t2X+b1*t1X+b0*t0X+b3)*cos(thetax_Z)*cos(thetay_Z)*cos(thetaz_Z)
												 +(b10*t2X+b9*t1X+b8*t0X+b11)*cos(thetax_Z)*sin(thetay_Z);

		jac[index + 8] =  -(b2*t2X+b1*t1X+b0*t0X+b3)*(cos(thetax_Z)*sin(thetay_Z)*sin(thetaz_Z)
				+sin(thetax_Z)*cos(thetaz_Z))
				-(b6*t2X+b5*t1X+b4*t0X+b7)*(cos(thetax_Z)*sin(thetay_Z)*cos(thetaz_Z)
						-sin(thetax_Z)*sin(thetaz_Z));

		jac[index + 9] =    0 ;
		jac[index + 10] =   0  ;
		jac[index + 11] =    -1 ;

		index += 12;


	}

}
void LevMarMethodWithAnglesRepII(vector<Matrix>& As, vector<Matrix>& Bs, Matrix& X, Matrix& Z, std::ofstream& out){

	CaliData C;
	C.As = &As;
	C.Bs = &Bs;

	// each matrix has 12 elements
	int n = As.size()*12;
	int m = 12;   // 3 angles each, then 3 translation compoenents each.

	double x[n];

	double opts[LM_OPTS_SZ], info[LM_INFO_SZ];

	opts[0]=LM_INIT_MU; opts[1]=1E-15; opts[2]=1E-15; opts[3]=1E-20;
	opts[4]= LM_DIFF_DELTA; // relevant only if the Jacobian is approximated using finite differences; specifies forward differencing

	for (int i = 0; i < n; i++){
		x[i] = 0;
	}

	// convert X, Z, into parameter vector
	double parameter_vector[12];
	for (int i = 0; i < m; i++){
		parameter_vector[i] = 0;
	}


	// we're solving for the inverse, so in case an initial non-zero solution is used, we need to invert
	X = X.i();

	vector<double> anglesX(3, 0);

	ExtractAnglesAndTransformAgain(X, anglesX);

	parameter_vector[0] = anglesX[0];
	parameter_vector[1] = anglesX[1];
	parameter_vector[2] = anglesX[2];

	parameter_vector[3] = X(1, 4);
	parameter_vector[4] = X(2, 4);
	parameter_vector[5] = X(3, 4);

	ExtractAnglesAndTransformAgain(Z, anglesX);

	parameter_vector[6] = anglesX[0];
	parameter_vector[7] = anglesX[1];
	parameter_vector[8] = anglesX[2];

	parameter_vector[9] = Z(1, 4);
	parameter_vector[10] = Z(2, 4);
	parameter_vector[11] = Z(3, 4);

	out << endl;
	out << "Intial solution ";
	for(int i=0; i<m; ++i){
		out <<	parameter_vector[i] << " ";
	}
	out << endl << endl;

	int ret = dlevmar_der(residuals_euler2, jacobian_euler2, parameter_vector, x, m, n, 1000, opts, info, NULL, NULL, &C); // with analytic Jacobian

	//printf("Results for %s:\n", probname[problem]);
	printf("Levenberg-Marquardt returned %d in %g iter, reason %g\nSolution: ", ret, info[5], info[6]);
	for(int i=0; i<m; ++i)
		printf("%.7g ", parameter_vector[i]);
	printf("\n\nMinimization info:\n");
	for(int i=0; i<LM_INFO_SZ; ++i)
		printf("%g ", info[i]);
	printf("\n");

	out << "Levenberg-Marquardt returned " << ret << " in " << info[5] << " iter, reason " << info[6] << endl;
	out << " Solution ";
	for(int i=0; i<m; ++i){
		out <<	parameter_vector[i] << " ";
	}
	out << endl << endl;

	out << "minimization information " << endl;
	for(int i=0; i<LM_INFO_SZ; ++i){
		out << info[i] << " ";
	}
	out << endl << endl;

	//R = Rx*Ry*Rz;
	// X params first, then Y params.
	Matrix Rx(3, 3);
	Matrix Ry(3, 3);
	Matrix Rz(3, 3);

	Rx.Row(1) << 1 <<  0 << 0;
	Rx.Row(2) << 0 << cos(parameter_vector[0]) << -sin(parameter_vector[0]);
	Rx.Row(3) << 0 << sin(parameter_vector[0]) << cos(parameter_vector[0]);

	Ry.Row(1) << cos(parameter_vector[1]) << 0 << sin(parameter_vector[1]);
	Ry.Row(2) << 0 << 1 << 0;
	Ry.Row(3) << -sin(parameter_vector[1]) << 0 << cos(parameter_vector[1]);

	Rz.Row(1) << cos(parameter_vector[2]) << -sin(parameter_vector[2]) << 0;
	Rz.Row(2) << sin(parameter_vector[2]) << cos(parameter_vector[2]) << 0;
	Rz.Row(3) << 0 << 0 << 1;


	X.SubMatrix(1, 3, 1, 3) = Rx*Ry*Rz;
	X(1, 4) = parameter_vector[3];
	X(2, 4) = parameter_vector[4];
	X(3, 4) = parameter_vector[5];

	Rx.Row(1) << 1 <<  0 << 0;
	Rx.Row(2) << 0 << cos(parameter_vector[6]) << -sin(parameter_vector[6]);
	Rx.Row(3) << 0 << sin(parameter_vector[6]) << cos(parameter_vector[6]);

	Ry.Row(1) << cos(parameter_vector[7]) << 0 << sin(parameter_vector[7]);
	Ry.Row(2) << 0 << 1 << 0;
	Ry.Row(3) << -sin(parameter_vector[7]) << 0 << cos(parameter_vector[7]);

	Rz.Row(1) << cos(parameter_vector[8]) << -sin(parameter_vector[8]) << 0;
	Rz.Row(2) << sin(parameter_vector[8]) << cos(parameter_vector[8]) << 0;
	Rz.Row(3) << 0 << 0 << 1;

	// do inverse b/c here we solved for X inverse.
	X = X.i();

	Z.SubMatrix(1, 3, 1, 3) = Rx*Ry*Rz;
	Z(1, 4) = parameter_vector[9];
	Z(2, 4) = parameter_vector[10];
	Z(3, 4) = parameter_vector[11];
}



void LevMarMethodReprojectionError2(vector<Matrix>& As, vector<Matrix>& Bs, Matrix& X, Matrix& Z, CaliObjectOpenCV2* CO, std::ofstream& out){

	// Here, we let X by X inverse ... so we need to reprocess before leaving ....
	CaliData C;
	C.As = &As;
	C.Bs = &Bs;
	C.CO = CO;

	ColumnVector world_c(3);
	for (int h=0; h< CO->chess_h; h++) {
		for (int w=0; w< CO->chess_w; w++) {
			world_c(1) = (double)(w * CO->mm_width);
			world_c(2) = (double)(h * CO->mm_height);
			world_c(3) = 0;

			C.world_coordinates.push_back(world_c);
		}
	}

	// each image has world_points.size() items ....
	int n = As.size()*C.world_coordinates.size()*2;
	int m = 17;   // 3 angles each, then 3 translation compoenents each + 5 components for K (angles X, trans X, andlges Z, trans Z, K parameters last.).

	double x[n];

	double opts[LM_OPTS_SZ], info[LM_INFO_SZ];

	opts[0]=LM_INIT_MU; opts[1]=1E-15; opts[2]=1E-15; opts[3]=1E-20;
	opts[4]= LM_DIFF_DELTA; // relevant only if the Jacobian is approximated using finite differences; specifies forward differencing

	// fill in using CO and undistort ....
	//int counter = 0;
	//cvmSet(corners2d, cnt, 0, (double)all_corners[cnt].x);   // image u
	//cvmSet(corners2d, cnt, 1, (double)all_corners[cnt].y);   // image v


	cv::Mat cameraMatrix = cv::Mat::eye(3, 3, CV_64F);
	cv::Mat distCoeffs = cv::Mat::zeros(8, 1, CV_64F);

	for (int i = 0; i < 3; i++){
		for (int j = 0; j < 3; j++){
			cameraMatrix.at<double>(i, j)  = CO->A[i][j];
		}
	}

	for (int i = 0; i < 8; i++){
		distCoeffs.at<double>(i, 0) = CO->k[i];
	}

	cout << "Cali matrix " << endl << cameraMatrix << endl;
	cout << "coefficients " << distCoeffs << endl;


	cv::Mat view, rview, map1, map2;

	// now, x are the corrected image values .....
	for (int i = 0; i < n; i++){
		x[i] = 0;
	}

	cv::Point2f point;


	for (int i = 0; i < int(CO->Rts.size()); i++){
		//	for (int i = 0; i < 1; i++){
		for (int j = 0; j < CO->chess_h * CO->chess_w; j++){

			// don't worry about distortion for
			point = CO->all_points[CO->number_internal_images_written + i][j];

			C.image_coordinates_x_y.push_back(point.x);
			C.image_coordinates_x_y.push_back(point.y);
		}

	}

	//cv:Size map_size = map1.size();
	cout << "Size of map is " << map1.rows << ", " << map1.cols << endl;

	cout << "n is " << n << endl;
	cout << "Number of image points is " << C.image_coordinates_x_y.size() << endl;

	// convert X, Z, into parameter vector

	double parameter_vector[n];
	for (int i = 0; i < m; i++){
		parameter_vector[i] = 0;
	}

	vector<double> anglesX(3, 0);

	parameter_vector[0] = CO->A[0][0];
	parameter_vector[1] = CO->A[0][1];
	parameter_vector[2] = CO->A[0][2];
	parameter_vector[3] = CO->A[1][1];
	parameter_vector[4] = CO->A[1][2];


	Matrix Xi = X.i();
	ExtractAnglesAndTransformAgain(Xi, anglesX);

	parameter_vector[5] = anglesX[0];
	parameter_vector[6] = anglesX[1];
	parameter_vector[7] = anglesX[2];

	parameter_vector[8] = Xi(1, 4);
	parameter_vector[9] = Xi(2, 4);
	parameter_vector[10] = Xi(3, 4);

	ExtractAnglesAndTransformAgain(Z, anglesX);

	parameter_vector[11] = anglesX[0];
	parameter_vector[12] = anglesX[1];
	parameter_vector[13] = anglesX[2];

	parameter_vector[14] = Z(1, 4);
	parameter_vector[15] = Z(2, 4);
	parameter_vector[16] = Z(3, 4);

	out << endl;
	out << "Intial solution ";
	for(int i=0; i<m; ++i){
		out <<	parameter_vector[i] << " ";
	}
	out << endl << endl;

	int ret;

	ret = dlevmar_der(residuals_reprojection2, jacobian_reprojection2, parameter_vector, x, m, n, 2000, opts, info, NULL, NULL, &C); // with analytic Jacobian
	//
	/* O: information regarding the minimization. Set to NULL if don't care
	 * info[0]= ||e||_2 at initial p.
	 * info[1-4]=[ ||e||_2, ||J^T e||_inf,  ||Dp||_2, mu/max[J^T J]_ii ], all computed at estimated p.
	 * info[5]= # iterations,
	 * info[6]=reason for terminating: 1 - stopped by small gradient J^T e
	 *                                 2 - stopped by small Dp
	 *                                 3 - stopped by itmax
	 *                                 4 - singular matrix. Restart from current p with increased mu
	 *                                 5 - no further error reduction is possible. Restart with increased mu
	 *                                 6 - stopped by small ||e||_2
	 *                                 7 - stopped by invalid (i.e. NaN or Inf) "func" values. This is a user error
	 * info[7]= # function evaluations
	 * info[8]= # Jacobian evaluations
	 * info[9]= # linear systems solved, i.e. # attempts for reducing error
	 */


	//printf("Results for %s:\n", probname[problem]);
	printf("Levenberg-Marquardt returned %d in %g iter, reason %g\nSolution: ", ret, info[5], info[6]);
	for(int i=0; i<m; ++i)
		printf("%.7g ", parameter_vector[i]);
	printf("\n\nMinimization info:\n");
	for(int i=0; i<LM_INFO_SZ; ++i)
		printf("%g ", info[i]);
	printf("\n");

	out << "Levenberg-Marquardt returned " << ret << " in " << info[5] << " iter, reason " << info[6] << endl;
	out << " Solution ";
	for(int i=0; i<m; ++i){
		out <<	parameter_vector[i] << " ";
	}
	out << endl << endl;

	out << "minimization information " << endl;
	for(int i=0; i<LM_INFO_SZ; ++i){
		out << info[i] << " ";
	}
	out << endl << endl;


	//R = Rx*Ry*Rz;
	// X params first, then Y params.
	Matrix Rx(3, 3);
	Matrix Ry(3, 3);
	Matrix Rz(3, 3);

	Rx.Row(1) << 1 <<  0 << 0;
	Rx.Row(2) << 0 << cos(parameter_vector[5]) << -sin(parameter_vector[5]);
	Rx.Row(3) << 0 << sin(parameter_vector[5]) << cos(parameter_vector[5]);

	Ry.Row(1) << cos(parameter_vector[6]) << 0 << sin(parameter_vector[6]);
	Ry.Row(2) << 0 << 1 << 0;
	Ry.Row(3) << -sin(parameter_vector[6]) << 0 << cos(parameter_vector[6]);

	Rz.Row(1) << cos(parameter_vector[7]) << -sin(parameter_vector[7]) << 0;
	Rz.Row(2) << sin(parameter_vector[7]) << cos(parameter_vector[7]) << 0;
	Rz.Row(3) << 0 << 0 << 1;


	// X is inverted ....
	X.SubMatrix(1, 3, 1, 3) = (Rx*Ry*Rz);
	X(1, 4) = parameter_vector[8];
	X(2, 4) = parameter_vector[9];
	X(3, 4) = parameter_vector[10];

	X = X.i();

	Rx.Row(1) << 1 <<  0 << 0;
	Rx.Row(2) << 0 << cos(parameter_vector[11]) << -sin(parameter_vector[11]);
	Rx.Row(3) << 0 << sin(parameter_vector[11]) << cos(parameter_vector[11]);

	Ry.Row(1) << cos(parameter_vector[12]) << 0 << sin(parameter_vector[12]);
	Ry.Row(2) << 0 << 1 << 0;
	Ry.Row(3) << -sin(parameter_vector[12]) << 0 << cos(parameter_vector[12]);

	Rz.Row(1) << cos(parameter_vector[13]) << -sin(parameter_vector[13]) << 0;
	Rz.Row(2) << sin(parameter_vector[13]) << cos(parameter_vector[13]) << 0;
	Rz.Row(3) << 0 << 0 << 1;


	Z.SubMatrix(1, 3, 1, 3) = Rx*Ry*Rz;
	Z(1, 4) = parameter_vector[14];
	Z(2, 4) = parameter_vector[15];
	Z(3, 4) = parameter_vector[16];

	CO->A[0][0] = parameter_vector[0];
	CO->A[0][1] = parameter_vector[1];
	CO->A[0][2] = parameter_vector[2];
	CO->A[1][1] = parameter_vector[3];
	CO->A[1][2] = parameter_vector[4];



}

void LevMarMethodReprojectionError3(vector<Matrix>& As, vector<Matrix>& Bs, Matrix& X, Matrix& Z, CaliObjectOpenCV2* CO, std::ofstream& out){

	// Here, we let X by X inverse ... so we need to reprocess before leaving ....
	CaliData C;
	C.As = &As;
	C.Bs = &Bs;
	C.CO = CO;

	ColumnVector world_c(3);
	for (int h=0; h< CO->chess_h; h++) {
		for (int w=0; w< CO->chess_w; w++) {
			world_c(1) = (double)(w * CO->mm_width);
			world_c(2) = (double)(h * CO->mm_height);
			world_c(3) = 0;

			C.world_coordinates.push_back(world_c);
		}
	}

	// each image has world_points.size() items ....
	int n = As.size()*C.world_coordinates.size()*2;
	int m = 25;   // 3 angles each, then 3 translation compoenents each + 5 components for K (angles X, trans X, andlges Z, trans Z, K parameters last.) + 8 distortion parameters.

	double x[n];

	double opts[LM_OPTS_SZ], info[LM_INFO_SZ];

	opts[0]=LM_INIT_MU; opts[1]=1E-15; opts[2]=1E-15; opts[3]=1E-20;
	opts[4]= LM_DIFF_DELTA; // relevant only if the Jacobian is approximated using finite differences; specifies forward differencing

	// fill in using CO and undistort ....
	cv::Mat cameraMatrix = cv::Mat::eye(3, 3, CV_64F);
	cv::Mat distCoeffs = cv::Mat::zeros(8, 1, CV_64F);

	for (int i = 0; i < 3; i++){
		for (int j = 0; j < 3; j++){
			cameraMatrix.at<double>(i, j)  = CO->A[i][j];
		}
	}

	for (int i = 0; i < 8; i++){
		distCoeffs.at<double>(i, 0) = CO->k[i];
	}

	cout << "Cali matrix " << endl << cameraMatrix << endl;
	cout << "coefficients " << distCoeffs << endl;


	cv::Mat view, rview, map1, map2;
	// now, x are the corrected image values .....
	for (int i = 0; i < n; i++){
		x[i] = 0;
	}

	cv::Point2f point;

	for (int i = 0; i < int(CO->Rts.size()); i++){
		for (int j = 0; j < CO->chess_h * CO->chess_w; j++){

			// don't worry about distortion for
			point = CO->all_points[CO->number_internal_images_written + i][j];

			C.image_coordinates_x_y.push_back(point.x);
			C.image_coordinates_x_y.push_back(point.y);

		}

	}
	cout << "Size of map is " << map1.rows << ", " << map1.cols << endl;
	cout << "n is " << n << endl;
	cout << "Number of image points is " << C.image_coordinates_x_y.size() << endl;

	// convert X, Z, into parameter vector
	double parameter_vector[n];
	for (int i = 0; i < m; i++){
		parameter_vector[i] = 0;
	}

	vector<double> anglesX(3, 0);

	parameter_vector[0] = CO->A[0][0];
	parameter_vector[1] = CO->A[0][1];
	parameter_vector[2] = CO->A[0][2];
	parameter_vector[3] = CO->A[1][1];
	parameter_vector[4] = CO->A[1][2];


	Matrix Xi = X.i();
	ExtractAnglesAndTransformAgain(Xi, anglesX);

	parameter_vector[5] = anglesX[0];
	parameter_vector[6] = anglesX[1];
	parameter_vector[7] = anglesX[2];

	parameter_vector[8] = Xi(1, 4);
	parameter_vector[9] = Xi(2, 4);
	parameter_vector[10] = Xi(3, 4);

	ExtractAnglesAndTransformAgain(Z, anglesX);

	parameter_vector[11] = anglesX[0];
	parameter_vector[12] = anglesX[1];
	parameter_vector[13] = anglesX[2];

	parameter_vector[14] = Z(1, 4);
	parameter_vector[15] = Z(2, 4);
	parameter_vector[16] = Z(3, 4);

	parameter_vector[17] = CO->k[0]; // dist1
	parameter_vector[18] = CO->k[1]; // dist2
	parameter_vector[19] = CO->k[2]; //p1
	parameter_vector[20] = CO->k[3]; //p2
	parameter_vector[21] = CO->k[4]; //dist3
	parameter_vector[22] = CO->k[5]; //dist4
	parameter_vector[23] = CO->k[6]; //dist5
	parameter_vector[24] = CO->k[7]; //dist6


	out << endl;
	out << "Intial solution ";
	for(int i=0; i<m; ++i){
		out <<	parameter_vector[i] << " ";
	}
	out << endl << endl;

	int ret;


	ret = dlevmar_der(residuals_reprojection3, jacobian_reprojection3, parameter_vector, x, m, n, 2000, opts, info, NULL, NULL, &C); // with analytic Jacobian
	//
	/* O: information regarding the minimization. Set to NULL if don't care
	 * info[0]= ||e||_2 at initial p.
	 * info[1-4]=[ ||e||_2, ||J^T e||_inf,  ||Dp||_2, mu/max[J^T J]_ii ], all computed at estimated p.
	 * info[5]= # iterations,
	 * info[6]=reason for terminating: 1 - stopped by small gradient J^T e
	 *                                 2 - stopped by small Dp
	 *                                 3 - stopped by itmax
	 *                                 4 - singular matrix. Restart from current p with increased mu
	 *                                 5 - no further error reduction is possible. Restart with increased mu
	 *                                 6 - stopped by small ||e||_2
	 *                                 7 - stopped by invalid (i.e. NaN or Inf) "func" values. This is a user error
	 * info[7]= # function evaluations
	 * info[8]= # Jacobian evaluations
	 * info[9]= # linear systems solved, i.e. # attempts for reducing error
	 */


	//printf("Results for %s:\n", probname[problem]);
	printf("Levenberg-Marquardt returned %d in %g iter, reason %g\nSolution: ", ret, info[5], info[6]);
	for(int i=0; i<m; ++i)
		printf("%.7g ", parameter_vector[i]);
	printf("\n\nMinimization info:\n");
	for(int i=0; i<LM_INFO_SZ; ++i)
		printf("%g ", info[i]);
	printf("\n");

	out << "Levenberg-Marquardt returned " << ret << " in " << info[5] << " iter, reason " << info[6] << endl;
	out << " Solution ";
	for(int i=0; i<m; ++i){
		out <<	parameter_vector[i] << " ";
	}
	out << endl << endl;

	out << "minimization information " << endl;
	for(int i=0; i<LM_INFO_SZ; ++i){
		out << info[i] << " ";
	}
	out << endl << endl;


	//R = Rx*Ry*Rz;
	// X params first, then Y params.
	Matrix Rx(3, 3);
	Matrix Ry(3, 3);
	Matrix Rz(3, 3);

	Rx.Row(1) << 1 <<  0 << 0;
	Rx.Row(2) << 0 << cos(parameter_vector[5]) << -sin(parameter_vector[5]);
	Rx.Row(3) << 0 << sin(parameter_vector[5]) << cos(parameter_vector[5]);

	Ry.Row(1) << cos(parameter_vector[6]) << 0 << sin(parameter_vector[6]);
	Ry.Row(2) << 0 << 1 << 0;
	Ry.Row(3) << -sin(parameter_vector[6]) << 0 << cos(parameter_vector[6]);

	Rz.Row(1) << cos(parameter_vector[7]) << -sin(parameter_vector[7]) << 0;
	Rz.Row(2) << sin(parameter_vector[7]) << cos(parameter_vector[7]) << 0;
	Rz.Row(3) << 0 << 0 << 1;


	// X is inverted ....
	X.SubMatrix(1, 3, 1, 3) = (Rx*Ry*Rz);
	X(1, 4) = parameter_vector[8];
	X(2, 4) = parameter_vector[9];
	X(3, 4) = parameter_vector[10];

	X = X.i();

	Rx.Row(1) << 1 <<  0 << 0;
	Rx.Row(2) << 0 << cos(parameter_vector[11]) << -sin(parameter_vector[11]);
	Rx.Row(3) << 0 << sin(parameter_vector[11]) << cos(parameter_vector[11]);

	Ry.Row(1) << cos(parameter_vector[12]) << 0 << sin(parameter_vector[12]);
	Ry.Row(2) << 0 << 1 << 0;
	Ry.Row(3) << -sin(parameter_vector[12]) << 0 << cos(parameter_vector[12]);

	Rz.Row(1) << cos(parameter_vector[13]) << -sin(parameter_vector[13]) << 0;
	Rz.Row(2) << sin(parameter_vector[13]) << cos(parameter_vector[13]) << 0;
	Rz.Row(3) << 0 << 0 << 1;


	Z.SubMatrix(1, 3, 1, 3) = Rx*Ry*Rz;
	Z(1, 4) = parameter_vector[14];
	Z(2, 4) = parameter_vector[15];
	Z(3, 4) = parameter_vector[16];

	CO->A[0][0] = parameter_vector[0];
	CO->A[0][1] = parameter_vector[1];
	CO->A[0][2] = parameter_vector[2];
	CO->A[1][1] = parameter_vector[3];
	CO->A[1][2] = parameter_vector[4];


	CO->k[0] = parameter_vector[17]; // dist1
	CO->k[1] = parameter_vector[18] ; // dist2
	CO->k[2] = parameter_vector[19]; //p1
	CO->k[3] = parameter_vector[20] ; //p2
	CO->k[4] = parameter_vector[21]; //dist3
	CO->k[5] = parameter_vector[22]; //dist4
	CO->k[6] = parameter_vector[23]; //dist5
	CO->k[7] = parameter_vector[24]; //dist6

}


double AssessError(vector<Matrix>& As, vector<Matrix>& Bs, Matrix& X, Matrix& Z){
	double error = 0;
	Matrix Htest(4, 4);
	for (int i = 0; i < int(Bs.size()); i++){
		// try once for now .....
		Htest = As[i]*X - Z*Bs[i];

		for (int r = 1; r <= 4; r++){
			for (int c = 1; c <= 4; c++){
				error = error + fabs(Htest(r, c));
			}
		}
	}
	return error;
}

double AssessErrorWhole(vector<Matrix>& As, vector<Matrix>& Bs, Matrix& X, Matrix& Z){
	double error = 0;
	Matrix Htest(4, 4);
	for (int i = 0; i < int(Bs.size()); i++){
		// try once for now .....
		Htest = As[i]*X - Z*Bs[i];

		for (int r = 1; r <= 4; r++){
			for (int c = 1; c <= 4; c++){
				error = error + pow(Htest(r, c), 2.0);
			}
		}
	}

	return error;
}

double AssessRotationError(vector<Matrix>& As, vector<Matrix>& Bs, Matrix& X, Matrix& Z){
	double error = 0;
	double local_error = 0;
	Matrix Htest(4, 4);
	Matrix R(3, 3);
	for (int i = 0; i < int(Bs.size()); i++){
		// try once for now .....
		R = As[i].SubMatrix(1, 3, 1, 3)*X.SubMatrix(1, 3, 1, 3) - Z.SubMatrix(1, 3, 1, 3)*Bs[i].SubMatrix(1, 3, 1, 3);
		local_error = 0;
		for (int r = 1; r <= 3; r++){
			for (int c = 1; c <= 3; c++){
				local_error += R(r, c)*R(r, c);
			}
		}

		//R.NormFrobenius()
		error += local_error;
	}

	return error;
}

double AssessTranslationError(vector<Matrix>& As, vector<Matrix>& Bs, Matrix& X, Matrix& Z){
	double error = 0;
	Matrix Htest(4, 4);
	Matrix R(3, 3);
	ColumnVector top_row(3);
	ColumnVector bottom_row(3);

	ColumnVector one_item;
	for (int i = 0; i < int(Bs.size()); i++){
		// try once for now .....
		top_row = As[i].SubMatrix(1, 3, 1, 3)*X.SubMatrix(1, 3, 4, 4) + As[i].SubMatrix(1, 3, 4, 4) - Z.SubMatrix(1, 3, 1, 3)*Bs[i].SubMatrix(1, 3, 4, 4) - Z.SubMatrix(1, 3, 4, 4);

		error += DotProduct(top_row, top_row);
	}

	return sqrt(error);
}

double AssessTranslationErrorDenominator(vector<Matrix>& As, vector<Matrix>& Bs, Matrix& X, Matrix& Z){
	double error = 0;
	Matrix Htest(4, 4);
	Matrix R(3, 3);
	ColumnVector top_row(3);
	ColumnVector bottom_row(3);

	ColumnVector one_item;


	for (int i = 0; i < int(Bs.size()); i++){
		// try once for now .....
		top_row = As[i].SubMatrix(1, 3, 1, 3)*X.SubMatrix(1, 3, 4, 4) + As[i].SubMatrix(1, 3, 4, 4);

		error += DotProduct(top_row, top_row);
	}

	return sqrt(error);
}

double CalculateReprojectionError(CaliObjectOpenCV2* CO, vector<Matrix>& As, vector<Matrix>& Bs, Matrix& X, Matrix& Z, std::ofstream& out, string directory){

	double reproj_error = 0;
	vector<cv::Point2f> imagePoints2;
	double err;
	Matrix newA(4, 4);

	vector<Matrix> newAs;
	cv::Mat R = cv::Mat::eye(3, 3, CV_64F);
	cv::Mat rvec = cv::Mat::zeros(3, 1, CV_64F);
	cv::Mat tvec = cv::Mat::zeros(3, 1, CV_64F);
	cv::Mat cameraMatrix = cv::Mat::eye(3, 3, CV_64F);
	cv::Mat distCoeffs = cv::Mat::zeros(8, 1, CV_64F);

	cv::Mat im;
	cv::Mat gray;

	for (int i = 0; i < 3; i++){
		for (int j = 0; j < 3; j++){
			cameraMatrix.at<double>(i, j)  = CO->A[i][j];
		}
	}

	for (int i = 0; i < 8; i++){
		distCoeffs.at<double>(i, 0) = CO->k[i];
	}

	string filename;
	for (int i = 0; i < int(As.size()); i++){

		newA = Z*Bs[i]*X.i();

		for (int r = 0; r < 3; r++){
			for (int c = 0; c < 3; c++){
				R.at<double>(r, c) = newA(r + 1, c + 1);
			}
			tvec.at<double>(r, 0) = newA(r + 1, 4);
		}

		cv::Rodrigues(R, rvec);

		cv::projectPoints( cv::Mat(CO->all_3d_corners[CO->number_internal_images_written + i]), rvec, tvec, cameraMatrix,  // project
				distCoeffs, imagePoints2);
		err = cv::norm(cv::Mat(CO->all_points[CO->number_internal_images_written + i]), cv::Mat(imagePoints2), CV_L2);              // difference

		reproj_error        += err*err;                                             // su

		im = CO->external_images[i].clone();
		cv::cvtColor(im, gray, CV_BGR2GRAY);
		cv::cvtColor(gray, im, CV_GRAY2BGR);


		for (int j = 0; j < int(imagePoints2.size()); j++){
			cv::line(im, imagePoints2[j], CO->all_points[CO->number_internal_images_written + i][j], cv::Scalar(255, 0, 0), 2, 8);
		}


		filename = directory + "/reproj" + ToString<int>(i) + ".png";

		cv::imwrite(filename.c_str(), im);

	}
	//<< setprecision(12)
	out << endl << "Summed reproj error "  << reproj_error << endl << endl;


	for (int i = 0; i < int(As.size()); i++){

		newA = Z*Bs[i]*X.i();


		out << "newA for i " << endl << newA << endl;
	}

	return reproj_error;
}


void ReadRobotFileDensoArm(string write_dir, vector<Matrix>& Bs){

	Matrix newR(3, 3);

	ColumnVector qt(4);
	ColumnVector cv(3);
	ColumnVector rv(3);
	double thetax, thetay, thetaz;

	Matrix Rx(3, 3);
	Matrix Ry(3, 3);
	Matrix Rz(3, 3);

	Matrix B1(4, 4);



	std::ifstream in;
	string filename = write_dir + "/robot.txt";

	in.open(filename.c_str());
	//cali_objects[0]->indices[i]
	ColumnVector r_v(6);
	vector<ColumnVector> robot_params;
	ColumnVector C(3);

	std::ofstream out;
	filename = write_dir + "/robot_cali.txt";
	out.open(filename.c_str());



	int N;
	in >> N;
	out << N << endl;

	cout << "filename " << filename << endl;
	for (int i = 0; i < N; i++){

		in >> r_v(1) >> r_v(2) >> r_v(3) >> r_v(4) >> r_v(5) >> r_v(6);

		cout << "r_v for " << i << "   " << r_v.t() << endl;
		// convert to rotation matrices .... no monkeying at the moment.

		C = r_v.SubMatrix(1, 3, 1, 1);

		C(1) = -C(1);

		thetax = r_v(4)*(3.14/180.0);
		thetay = r_v(5)*(3.14/180.0);;
		thetaz = r_v(6)*(3.14/180.0);;

		thetaz = -thetaz;
		C(2) = -C(2);

		Rz.Row(1) << cos(thetaz) << -sin(thetaz) << 0;
		Rz.Row(2) << sin(thetaz) << cos(thetaz) << 0;
		Rz.Row(3) << 0 << 0 << 1;

		Ry.Row(1) << cos(thetay) << 0 << sin(thetay);
		Ry.Row(2) << 0 << 1 << 0;
		Ry.Row(3) << -sin(thetay) << 0 << cos(thetay);

		Rx.Row(1) << 1 << 0 << 0;
		Rx.Row(2) << 0 << cos(thetax) << -sin(thetax);
		Rx.Row(3) << 0 << sin(thetax) << cos(thetax);


		newR = Rx*Ry*Rz;

		//newR = newR.t();

		Rz.Row(1) << cos(3.14*3.0/2.0) << -sin(3.14*3.0/2.0) << 0;
		Rz.Row(2) << sin(3.14*3.0/2.0) << cos(3.14*3.0/2.0) << 0;
		Rz.Row(3) << 0 << 0 << 1;

		newR = Rz*newR;


		B1 = 0;
		B1(4, 4) = 1;

		B1.SubMatrix(1, 3, 1, 3) = newR;
		B1.SubMatrix(1, 3, 4, 4) = -newR*C;

		Bs.push_back(B1);

		out << B1 << endl;

		// this accomplishes the transformation from the robot parameters to the correct coordinate system.

	}
	in.close();
	out.close();
}

void ReadRobotFileRobotCaliTxt(string write_dir, vector<Matrix>& Bs){

	Matrix newR(3, 3);

	ColumnVector qt(4);
	ColumnVector cv(3);
	ColumnVector rv(3);

	Matrix Rx(3, 3);
	Matrix Ry(3, 3);
	Matrix Rz(3, 3);

	Matrix B1(4, 4);



	std::ifstream in;
	string filename = write_dir + "/robot_cali.txt";

	in.open(filename.c_str());

	ColumnVector r_v(6);
	vector<ColumnVector> robot_params;
	ColumnVector C(3);

	std::ofstream out;
	filename = write_dir + "/robot_cali.txt";
	out.open(filename.c_str());


	int N;
	in >> N;

	for (int i = 0; i < N; i++){

		for (int r = 1; r <= 4; r++){
			for (int c = 1; c <= 4; c++){
				in >> B1(r, c);
			}
		}

		Bs.push_back(B1);
	}
	in.close();
}



